/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.test.component.BuildResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;

public class QuarkusComponentTestClassLoader
extends ClassLoader {
    private static final Logger LOG = Logger.getLogger(QuarkusComponentTestClassLoader.class);
    static final ConcurrentMap<String, Bytecode> BYTECODE_CACHE;
    private static final Set<String> PARENT_CL_CLASSES;
    private final String name;
    private final BuildResult buildResult;

    public QuarkusComponentTestClassLoader(ClassLoader parent, String name, BuildResult buildResult) {
        super(parent);
        this.name = name;
        this.buildResult = buildResult;
    }

    @Override
    public String getName() {
        return "QuarkusComponentTestClassLoader: " + this.name;
    }

    public Map<String, Set<String>> getConfigMappings() {
        return this.buildResult.configMappings();
    }

    public Map<String, String[]> getInterceptorMethods() {
        return this.buildResult.interceptorMethods();
    }

    public Throwable getBuildFailure() {
        return this.buildResult.failure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            byte[] bytecode = null;
            if (this.buildResult.generatedClasses() != null && (bytecode = this.buildResult.generatedClasses().get(name)) != null) {
                LOG.debugf("Use generated/transformed class for %s", (Object)name);
            }
            if (bytecode == null && !QuarkusComponentTestClassLoader.mustDelegateToParent(name)) {
                bytecode = BYTECODE_CACHE.computeIfAbsent(name, this::loadBytecode).value();
            }
            if (bytecode != null) {
                LOG.debugf("Define class %s", (Object)name);
                clazz = this.defineClass(name, bytecode, 0, bytecode.length);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(name, resolve);
        }
    }

    private Bytecode loadBytecode(String name) {
        byte[] bytecode = null;
        String path = name.replace('.', '/') + ".class";
        try (InputStream in = this.getParent().getResourceAsStream(path);){
            if (in != null) {
                LOG.debugf("Loading class %s", (Object)name);
                bytecode = in.readAllBytes();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Bytecode(bytecode);
    }

    private static boolean mustDelegateToParent(String name) {
        return name.startsWith("java.") || name.startsWith("jdk.") || name.startsWith("javax.") || name.startsWith("jakarta.") || name.startsWith("sun.") || name.startsWith("com.sun.") || name.startsWith("org.w3c.") || name.startsWith("org.xml.") || name.startsWith("org.junit.") || name.startsWith("org.mockito.") || name.startsWith("org.jboss.logging") || name.startsWith("org.jboss.logmanager") || name.startsWith("org.slf4j") || PARENT_CL_CLASSES.contains(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LOG.debugf("Get resource: %s", (Object)name);
        if ("META-INF/services/io.quarkus.arc.ComponentsProvider".equals(name)) {
            File tempFile = File.createTempFile(this.name + "_ComponentsProvider", null);
            tempFile.deleteOnExit();
            Files.write(tempFile.toPath(), this.buildResult.componentsProvider(), new OpenOption[0]);
            LOG.debugf("ComponentsProvider tmp file written: %s", (Object)tempFile);
            return Collections.enumeration(List.of(tempFile.toURI().toURL()));
        }
        return super.getResources(name);
    }

    public String toString() {
        return this.getName();
    }

    static {
        ClassLoader.registerAsParallelCapable();
        BYTECODE_CACHE = new ConcurrentHashMap<String, Bytecode>();
        PARENT_CL_CLASSES = Set.of("io.quarkus.test.component.QuarkusComponentTestClassLoader", "io.quarkus.dev.testing.TracingHandler");
    }

    record Bytecode(byte[] value) {
    }
}

