/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.test.common.FacadeClassLoaderProvider;
import io.quarkus.test.component.ComponentContainer;
import io.quarkus.test.component.QuarkusComponentTestClassLoader;
import io.quarkus.test.component.QuarkusComponentTestConfiguration;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.jboss.logging.Logger;

public class QuarkusComponentFacadeClassLoaderProvider
implements FacadeClassLoaderProvider {
    private static final Logger LOG = Logger.getLogger(QuarkusComponentFacadeClassLoaderProvider.class);
    private final Class<?> testClass;
    private final Set<String> tracedClasses;

    public QuarkusComponentFacadeClassLoaderProvider() {
        this(null, Set.of());
    }

    public QuarkusComponentFacadeClassLoaderProvider(Class<?> testClass, Set<String> tracedClasses) {
        this.testClass = testClass;
        this.tracedClasses = tracedClasses;
    }

    public ClassLoader getClassLoader(String name, ClassLoader parent) {
        QuarkusComponentTestConfiguration configuration = null;
        boolean buildShouldFail = false;
        Class<?> inspectionClass = this.testClass;
        if (inspectionClass == null) {
            try {
                inspectionClass = QuarkusComponentFacadeClassLoaderProvider.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LOG.warnf("Inspection class not found: %s [CL=%s]", (Object)name, (Object)QuarkusComponentFacadeClassLoaderProvider.class.getClassLoader());
                return null;
            }
        }
        for (Annotation a : inspectionClass.getAnnotations()) {
            if (!a.annotationType().getName().equals("io.quarkus.test.component.QuarkusComponentTest")) continue;
            configuration = QuarkusComponentTestConfiguration.DEFAULT.update(inspectionClass);
            break;
        }
        if (configuration == null) {
            for (Field field : inspectionClass.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().getName().equals("io.quarkus.test.component.QuarkusComponentTestExtension")) continue;
                try {
                    field.setAccessible(true);
                    QuarkusComponentTestExtension extension = (QuarkusComponentTestExtension)field.get(null);
                    buildShouldFail = extension.isBuildShouldFail();
                    configuration = extension.baseConfiguration.update(inspectionClass);
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to read configuration from field: " + String.valueOf(field), e);
                }
            }
        }
        if (configuration != null) {
            try {
                LOG.debugf("Created QuarkusComponentTestClassLoader for %s", inspectionClass);
                return new QuarkusComponentTestClassLoader(parent, name, ComponentContainer.build(inspectionClass, configuration, buildShouldFail, this.tracedClasses));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to build container for %s".formatted(name), e);
            }
        }
        return null;
    }
}

