/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.All;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ArcInitConfig;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.EventBean;
import io.quarkus.arc.impl.InstanceImpl;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.test.InjectMock;
import io.quarkus.test.component.ConfigBeanCreator;
import io.quarkus.test.component.ConfigMappingBeanCreator;
import io.quarkus.test.component.InterceptorMethodCreator;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.MockBeanCreator;
import io.quarkus.test.component.QuarkusComponentTestCallbacks;
import io.quarkus.test.component.QuarkusComponentTestClassLoader;
import io.quarkus.test.component.QuarkusComponentTestConfigSource;
import io.quarkus.test.component.QuarkusComponentTestConfiguration;
import io.quarkus.test.component.QuarkusComponentTestExtensionBuilder;
import io.quarkus.test.component.SkipInject;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestReporter;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.Mock;
import org.mockito.Mockito;

public class QuarkusComponentTestExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor,
ParameterResolver {
    private static final Logger LOG = Logger.getLogger(QuarkusComponentTestExtension.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{QuarkusComponentTestExtension.class});
    private static final String KEY_OLD_TCCL = "oldTccl";
    private static final String KEY_OLD_CONFIG_PROVIDER_RESOLVER = "oldConfigProviderResolver";
    private static final String KEY_GENERATED_RESOURCES = "generatedResources";
    private static final String KEY_INJECTED_FIELDS = "injectedFields";
    private static final String KEY_INJECTED_PARAMS = "injectedParams";
    static final String KEY_TEST_INSTANCE = "testInstance";
    private static final String KEY_CONFIG = "config";
    private static final String KEY_TEST_CLASS_CONFIG = "testClassConfig";
    private static final String KEY_CONFIG_MAPPINGS = "configMappings";
    private static final String KEY_CONTAINER_STATE = "containerState";
    final QuarkusComponentTestConfiguration baseConfiguration;
    private final boolean buildShouldFail;
    private final AtomicReference<Throwable> buildFailure;
    static final Predicate<Parameter> BUILTIN_PARAMETER = new Predicate<Parameter>(){

        @Override
        public boolean test(Parameter parameter) {
            if (parameter.isAnnotationPresent(TempDir.class)) {
                return true;
            }
            Type type = parameter.getParameterizedType();
            return type.equals(TestInfo.class) || type.equals(RepetitionInfo.class) || type.equals(TestReporter.class);
        }
    };
    static final DotName ALL_NAME = DotName.createSimple(All.class);

    public static QuarkusComponentTestExtensionBuilder builder() {
        return new QuarkusComponentTestExtensionBuilder();
    }

    public QuarkusComponentTestExtension() {
        this(QuarkusComponentTestConfiguration.DEFAULT, false);
    }

    public QuarkusComponentTestExtension(Class<?> ... additionalComponentClasses) {
        this(new QuarkusComponentTestConfiguration(Map.of(), Set.of(additionalComponentClasses), List.of(), false, true, 500, List.of(), List.of(), null, false, null), false);
    }

    QuarkusComponentTestExtension(QuarkusComponentTestConfiguration baseConfiguration, boolean startShouldFail) {
        this.baseConfiguration = baseConfiguration;
        this.buildShouldFail = startShouldFail;
        this.buildFailure = new AtomicReference();
    }

    boolean isBuildShouldFail() {
        return this.buildShouldFail;
    }

    public Throwable getBuildFailure() {
        return this.buildFailure.get();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        if (context.getRequiredTestClass().isAnnotationPresent(Nested.class)) {
            this.cleanup(context);
        }
        this.initContainer(context);
        this.startContainer(context, TestInstance.Lifecycle.PER_CLASS);
        LOG.debugf("beforeAll: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        this.stopContainer(context, TestInstance.Lifecycle.PER_CLASS);
        this.cleanup(context);
        LOG.debugf("afterAll: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        this.startContainer(context, TestInstance.Lifecycle.PER_METHOD);
        if (this.getContainerState(context) == ContainerState.STARTED) {
            Arc.container().requestContext().activate();
        }
        LOG.debugf("beforeEach: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        if (this.getContainerState(context) == ContainerState.STARTED) {
            Arc.container().requestContext().terminate();
            this.destroyDependentTestMethodParams(context);
        }
        this.stopContainer(context, TestInstance.Lifecycle.PER_METHOD);
        LOG.debugf("afterEach: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        QuarkusComponentTestExtension.store(context).put((Object)KEY_TEST_INSTANCE, testInstance);
        LOG.debugf("postProcessTestInstance: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.getTarget().isPresent() && QuarkusComponentTestExtension.isTestMethod(parameterContext.getDeclaringExecutable()) && !parameterContext.isAnnotated(SkipInject.class) && !parameterContext.getDeclaringExecutable().isAnnotationPresent(SkipInject.class) && !parameterContext.isAnnotated(Mock.class) && !BUILTIN_PARAMETER.test(parameterContext.getParameter())) {
            Object[] qualifiers;
            BeanManager beanManager = Arc.container().beanManager();
            Type requiredType = parameterContext.getParameter().getParameterizedType();
            if (QuarkusComponentTestExtension.isListAllInjectionPoint(requiredType, (Annotation[])(qualifiers = QuarkusComponentTestExtension.getQualifiers(parameterContext.getAnnotatedElement(), beanManager)), parameterContext.getParameter())) {
                return true;
            }
            try {
                Bean bean = beanManager.resolve(beanManager.getBeans(requiredType, (Annotation[])qualifiers));
                if (bean == null) {
                    String msg = String.format("No matching bean found for the type [%s] and qualifiers %s", requiredType, Arrays.toString(qualifiers));
                    if (parameterContext.isAnnotated(InjectMock.class) || qualifiers.length > 0) {
                        throw new IllegalStateException(msg);
                    }
                    LOG.info((Object)(msg + " - consider annotating the parameter with @SkipInject"));
                    return false;
                }
                return true;
            }
            catch (AmbiguousResolutionException e) {
                String msg = String.format("Multiple matching beans found for the type [%s] and qualifiers %s\n\t- if this parameter should not be resolved by CDI then use @SkipInject\n\t- found beans: %s", requiredType, Arrays.toString(qualifiers), e.getMessage());
                throw new IllegalStateException(msg);
            }
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        List injectedParams = (List)QuarkusComponentTestExtension.store(context).get((Object)KEY_INJECTED_PARAMS, List.class);
        ArcContainer container = Arc.container();
        BeanManager beanManager = container.beanManager();
        Type requiredType = parameterContext.getParameter().getParameterizedType();
        Annotation[] qualifiers = QuarkusComponentTestExtension.getQualifiers(parameterContext.getAnnotatedElement(), beanManager);
        if (Instance.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            InstanceImpl instance = InstanceImpl.forGlobalEntrypoint((Type)QuarkusComponentTestExtension.getFirstActualTypeArgument(requiredType), Set.of(qualifiers));
            injectedParams.add(instance);
            return instance;
        }
        if (QuarkusComponentTestExtension.isListAllInjectionPoint(requiredType, qualifiers, parameterContext.getParameter())) {
            ArrayList unsetHandles = new ArrayList();
            Object ret = QuarkusComponentTestExtension.handleListAll(requiredType, qualifiers, container, unsetHandles);
            unsetHandles.forEach(injectedParams::add);
            return ret;
        }
        InstanceHandle handle = container.instance(requiredType, qualifiers);
        injectedParams.add(handle);
        return handle.get();
    }

    private void destroyDependentTestMethodParams(ExtensionContext context) {
        List injectedParams = (List)QuarkusComponentTestExtension.store(context).get((Object)KEY_INJECTED_PARAMS, List.class);
        for (Object param : injectedParams) {
            if (param instanceof InstanceHandle) {
                InstanceHandle handle = (InstanceHandle)param;
                if (handle.getBean() == null || !handle.getBean().getScope().equals(Dependent.class)) continue;
                try {
                    handle.destroy();
                }
                catch (Exception e) {
                    LOG.errorf((Throwable)e, "Unable to destroy the injected %s", (Object)handle.getBean());
                }
                continue;
            }
            if (!(param instanceof InstanceImpl)) continue;
            InstanceImpl instance = (InstanceImpl)param;
            instance.destroy();
        }
        injectedParams.clear();
    }

    private void initContainer(ExtensionContext context) {
        if (this.getContainerState(context) != ContainerState.UNINITIALIZED) {
            return;
        }
        QuarkusComponentTestConfiguration testClassConfiguration = this.baseConfiguration.update(context.getRequiredTestClass());
        QuarkusComponentTestExtension.store(context).put((Object)KEY_TEST_CLASS_CONFIG, (Object)testClassConfiguration);
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        Class testClass = context.getRequiredTestClass();
        ClassLoader testCl = testClass.getClassLoader();
        Thread.currentThread().setContextClassLoader(testCl);
        if (testCl instanceof QuarkusComponentTestClassLoader) {
            QuarkusComponentTestClassLoader componentCl = (QuarkusComponentTestClassLoader)testCl;
            Map<String, Set<String>> configMappings = componentCl.getConfigMappings();
            if (!configMappings.isEmpty()) {
                HashSet<ConfigMappings.ConfigClass> mappings = new HashSet<ConfigMappings.ConfigClass>();
                for (Map.Entry<String, Set<String>> e : configMappings.entrySet()) {
                    for (String mapping : e.getValue()) {
                        mappings.add(ConfigMappings.ConfigClass.configClass(ConfigMappingBeanCreator.tryLoad(mapping), (String)e.getKey()));
                    }
                }
                QuarkusComponentTestExtension.store(context).put((Object)KEY_CONFIG_MAPPINGS, mappings);
            }
            try {
                InterceptorMethodCreator.register(context, componentCl.getInterceptorMethods());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to register interceptor methods", e);
            }
            this.buildFailure.set(componentCl.getBuildFailure());
        }
        for (MockBeanConfiguratorImpl<?> mockBeanConfigurator : testClassConfiguration.mockConfigurators) {
            MockBeanCreator.registerCreate(testClass.getName(), (Function)QuarkusComponentTestExtension.cast(mockBeanConfigurator.create));
        }
        if (this.buildFailure.get() == null) {
            QuarkusComponentTestExtension.store(context).put((Object)KEY_OLD_TCCL, (Object)oldTccl);
            this.setContainerState(context, ContainerState.INITIALIZED);
        } else {
            this.setContainerState(context, ContainerState.BUILD_FAILED);
        }
    }

    private void cleanup(ExtensionContext context) {
        if (this.getContainerState(context).requiresCleanup()) {
            ClassLoader oldTccl = (ClassLoader)QuarkusComponentTestExtension.store(context).get((Object)KEY_OLD_TCCL, ClassLoader.class);
            if (oldTccl != null) {
                Thread.currentThread().setContextClassLoader(oldTccl);
            }
            QuarkusComponentTestExtension.store(context).remove((Object)KEY_OLD_TCCL);
            QuarkusComponentTestExtension.store(context).remove((Object)KEY_CONFIG_MAPPINGS);
            Set generatedResources = (Set)QuarkusComponentTestExtension.store(context).get((Object)KEY_GENERATED_RESOURCES, Set.class);
            if (generatedResources != null) {
                for (Path path : generatedResources) {
                    try {
                        LOG.debugf("Delete generated %s", (Object)path);
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        LOG.errorf("Unable to delete the generated resource %s: ", (Object)path, (Object)e.getMessage());
                    }
                }
            }
            QuarkusComponentTestExtension.store(context).remove((Object)KEY_GENERATED_RESOURCES);
            this.setContainerState(context, ContainerState.UNINITIALIZED);
        }
    }

    private void stopContainer(ExtensionContext context, TestInstance.Lifecycle testInstanceLifecycle) throws Exception {
        if (testInstanceLifecycle.equals((Object)context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD)) && this.getContainerState(context) == ContainerState.STARTED) {
            for (FieldInjector fieldInjector : (List)QuarkusComponentTestExtension.store(context).get((Object)KEY_INJECTED_FIELDS, List.class)) {
                fieldInjector.unset();
            }
            try {
                Arc.shutdown();
            }
            catch (Exception e) {
                LOG.error((Object)("An error occured during ArC shutdown: " + String.valueOf(e)));
            }
            MockBeanCreator.clear();
            ConfigBeanCreator.clear();
            InterceptorMethodCreator.clear();
            QuarkusComponentTestExtension.store(context).remove((Object)KEY_CONTAINER_STATE);
            SmallRyeConfig config = (SmallRyeConfig)QuarkusComponentTestExtension.store(context).get((Object)KEY_CONFIG, SmallRyeConfig.class);
            ConfigProviderResolver.instance().releaseConfig((Config)config);
            ConfigProviderResolver oldConfigProviderResolver = (ConfigProviderResolver)QuarkusComponentTestExtension.store(context).get((Object)KEY_OLD_CONFIG_PROVIDER_RESOLVER, ConfigProviderResolver.class);
            ConfigProviderResolver.setInstance((ConfigProviderResolver)oldConfigProviderResolver);
            this.setContainerState(context, ContainerState.STOPPED);
            QuarkusComponentTestConfiguration configuration = (QuarkusComponentTestConfiguration)QuarkusComponentTestExtension.store(context).get((Object)KEY_TEST_CLASS_CONFIG, QuarkusComponentTestConfiguration.class);
            if (configuration.hasCallbacks()) {
                AfterStopContextImpl afterStopContext = new AfterStopContextImpl(context.getRequiredTestClass());
                for (QuarkusComponentTestCallbacks callbacks : configuration.callbacks) {
                    callbacks.afterStop(afterStopContext);
                }
            }
        }
    }

    private ContainerState getContainerState(ExtensionContext context) {
        ContainerState state = (ContainerState)((Object)QuarkusComponentTestExtension.store(context).get((Object)KEY_CONTAINER_STATE, ContainerState.class));
        return state != null ? state : ContainerState.UNINITIALIZED;
    }

    private void setContainerState(ExtensionContext context, ContainerState state) {
        QuarkusComponentTestExtension.store(context).put((Object)KEY_CONTAINER_STATE, (Object)state);
    }

    private void startContainer(ExtensionContext context, TestInstance.Lifecycle testInstanceLifecycle) throws Exception {
        Set configMappings;
        Map<String, String> configProperties;
        if (!testInstanceLifecycle.equals((Object)context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD))) {
            return;
        }
        ContainerState state = this.getContainerState(context);
        if (state == ContainerState.UNINITIALIZED) {
            throw new IllegalStateException("Container not initialized");
        }
        if (state == ContainerState.STARTED || state == ContainerState.BUILD_FAILED) {
            return;
        }
        Arc.initialize((ArcInitConfig)ArcInitConfig.builder().setTestMode(true).build());
        QuarkusComponentTestConfiguration configuration = (QuarkusComponentTestConfiguration)QuarkusComponentTestExtension.store(context).get((Object)KEY_TEST_CLASS_CONFIG, QuarkusComponentTestConfiguration.class);
        Optional testMethod = context.getTestMethod();
        if (testMethod.isPresent()) {
            configuration = configuration.update((Method)testMethod.get());
        }
        if (configuration.hasCallbacks()) {
            BeforeStartContextImpl beforeStartContext = new BeforeStartContextImpl(context.getRequiredTestClass(), configuration.configProperties);
            for (QuarkusComponentTestCallbacks callbacks : configuration.callbacks) {
                callbacks.beforeStart(beforeStartContext);
            }
            configProperties = Map.copyOf(beforeStartContext.configProperties);
        } else {
            configProperties = configuration.configProperties;
        }
        ConfigProviderResolver oldConfigProviderResolver = ConfigProviderResolver.instance();
        QuarkusComponentTestExtension.store(context).put((Object)KEY_OLD_CONFIG_PROVIDER_RESOLVER, (Object)oldConfigProviderResolver);
        SmallRyeConfigProviderResolver smallRyeConfigProviderResolver = new SmallRyeConfigProviderResolver();
        ConfigProviderResolver.setInstance((ConfigProviderResolver)smallRyeConfigProviderResolver);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        SmallRyeConfigBuilder configBuilder = new SmallRyeConfigBuilder().forClassLoader(tccl).addDefaultInterceptors().withConverters(configuration.configConverters.toArray(new Converter[0])).addPropertiesSources().withSources(new ConfigSource[]{new QuarkusComponentTestConfigSource(configProperties, configuration.configSourceOrdinal)});
        if (configuration.useSystemConfigSources) {
            configBuilder.addSystemSources();
        }
        if ((configMappings = (Set)QuarkusComponentTestExtension.store(context).get((Object)KEY_CONFIG_MAPPINGS, Set.class)) != null) {
            for (ConfigMappings.ConfigClass mapping : configMappings) {
                configBuilder.withMapping(mapping);
            }
        }
        if (configuration.configBuilderCustomizer != null) {
            configuration.configBuilderCustomizer.accept(configBuilder);
        }
        SmallRyeConfig config = configBuilder.build();
        smallRyeConfigProviderResolver.registerConfig((Config)config, tccl);
        QuarkusComponentTestExtension.store(context).put((Object)KEY_CONFIG, (Object)config);
        ConfigBeanCreator.setClassLoader(tccl);
        ArrayList<FieldInjector> injectedFields = new ArrayList<FieldInjector>();
        for (Object testInstance : context.getRequiredTestInstances().getAllInstances()) {
            injectedFields.addAll(this.injectFields(testInstance.getClass(), testInstance));
        }
        QuarkusComponentTestExtension.store(context).put((Object)KEY_INJECTED_FIELDS, injectedFields);
        QuarkusComponentTestExtension.store(context).put((Object)KEY_INJECTED_PARAMS, new CopyOnWriteArrayList());
        this.setContainerState(context, ContainerState.STARTED);
        if (configuration.hasCallbacks()) {
            AfterStartContextImpl afterStartContext = new AfterStartContextImpl(context.getRequiredTestClass());
            for (QuarkusComponentTestCallbacks callbacks : configuration.callbacks) {
                callbacks.afterStart(afterStartContext);
            }
        }
    }

    static ExtensionContext.Store store(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    private static Annotation[] getQualifiers(AnnotatedElement element, BeanManager beanManager) {
        Annotation[] annotations;
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        for (Annotation fieldAnnotation : annotations = element.getDeclaredAnnotations()) {
            if (!beanManager.isQualifier(fieldAnnotation.annotationType())) continue;
            ret.add(fieldAnnotation);
        }
        if (ret.isEmpty()) {
            ret.add((Annotation)Default.Literal.INSTANCE);
        }
        return ret.toArray(new Annotation[0]);
    }

    static <T> T cast(Object obj) {
        return (T)obj;
    }

    private List<FieldInjector> injectFields(Class<?> testClass, Object testInstance) throws Exception {
        ArrayList<FieldInjector> injectedFields = new ArrayList<FieldInjector>();
        for (Field field : this.findInjectFields(testClass, false)) {
            injectedFields.add(new FieldInjector(field, testInstance));
        }
        return injectedFields;
    }

    private List<Field> findInjectFields(Class<?> testClass, boolean scanEnclosingClasses) {
        List<Field> injectSpies;
        Class<? extends Annotation> injectSpy = this.loadInjectSpy();
        List<Class<? extends Annotation>> injectAnnotations = injectSpy != null ? List.of(Inject.class, InjectMock.class, injectSpy) : List.of(Inject.class, InjectMock.class);
        List<Field> found = this.findFields(testClass, injectAnnotations);
        if (scanEnclosingClasses) {
            for (Class<?> enclosing = testClass.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                found.addAll(this.findFields(enclosing, injectAnnotations));
            }
        }
        if (injectSpy != null && !(injectSpies = found.stream().filter(f -> f.isAnnotationPresent(injectSpy)).toList()).isEmpty()) {
            throw new IllegalStateException("@InjectSpy is not supported by QuarkusComponentTest: " + String.valueOf(injectSpies));
        }
        return found;
    }

    private Class<? extends Annotation> loadInjectSpy() {
        try {
            return Class.forName("io.quarkus.test.junit.mockito.InjectSpy");
        }
        catch (Throwable e) {
            return null;
        }
    }

    static boolean isTestMethod(Executable method) {
        return method.isAnnotationPresent(Test.class) || method.isAnnotationPresent(ParameterizedTest.class) || method.isAnnotationPresent(RepeatedTest.class);
    }

    private List<Field> findFields(Class<?> testClass, List<Class<? extends Annotation>> annotations) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            block1: for (Field field : current.getDeclaredFields()) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                    continue block1;
                }
            }
            current = current.getSuperclass();
        }
        return fields;
    }

    private static Object handleListAll(Type requiredType, Annotation[] qualifiers, ArcContainer container, Collection<InstanceHandle<?>> unsetHandles) {
        HashSet qualifiersSet = new HashSet();
        Collections.addAll(qualifiersSet, qualifiers);
        qualifiersSet.remove(All.Literal.INSTANCE);
        qualifiers = qualifiersSet.isEmpty() ? new Annotation[]{Default.Literal.INSTANCE} : qualifiersSet.toArray(new Annotation[0]);
        List handles = container.listAll(QuarkusComponentTestExtension.getFirstActualTypeArgument(requiredType), qualifiers);
        unsetHandles.addAll(handles);
        return QuarkusComponentTestExtension.isTypeArgumentInstanceHandle(requiredType) ? handles : handles.stream().map(InstanceHandle::get).collect(Collectors.toUnmodifiableList());
    }

    private static boolean isListRequiredType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return List.class.equals((Object)parameterizedType.getRawType());
        }
        return false;
    }

    static boolean isListAllInjectionPoint(Type requiredType, Annotation[] qualifiers, AnnotatedElement annotatedElement) {
        if (qualifiers.length > 0) {
            if (Arrays.stream(qualifiers).anyMatch(arg_0 -> ((All.Literal)All.Literal.INSTANCE).equals(arg_0))) {
                if (!QuarkusComponentTestExtension.isListRequiredType(requiredType)) {
                    throw new IllegalStateException("Invalid injection point type: " + String.valueOf(annotatedElement));
                }
                return true;
            }
        }
        return false;
    }

    static void adaptListAllQualifiers(Set<AnnotationInstance> qualifiers) {
        qualifiers.removeIf(a -> a.name().equals((Object)ALL_NAME));
        if (qualifiers.isEmpty()) {
            qualifiers.add(AnnotationInstance.builder(Default.class).build());
        }
    }

    static Type getFirstActualTypeArgument(Type requiredType) {
        if (requiredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)requiredType;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private static boolean isTypeArgumentInstanceHandle(Type type) {
        Type typeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (typeArgument instanceof ParameterizedType) {
            return ((ParameterizedType)typeArgument).getRawType().equals(InstanceHandle.class);
        }
        return false;
    }

    static enum ContainerState {
        UNINITIALIZED,
        INITIALIZED,
        BUILD_FAILED,
        STARTED,
        STOPPED;


        boolean requiresCleanup() {
            return this == STOPPED || this == BUILD_FAILED;
        }
    }

    static class FieldInjector {
        private final Object testInstance;
        private final Field field;
        private final Runnable unsetAction;

        public FieldInjector(Field field, Object testInstance) throws Exception {
            Object injectedInstance;
            this.field = field;
            this.testInstance = testInstance;
            ArcContainer container = Arc.container();
            BeanManager beanManager = container.beanManager();
            Type requiredType = field.getGenericType();
            Annotation[] qualifiers = QuarkusComponentTestExtension.getQualifiers(field, beanManager);
            boolean isMock = field.isAnnotationPresent(InjectMock.class);
            if (Instance.class.isAssignableFrom(QuarkusComponentTestConfiguration.getRawType(requiredType))) {
                InstanceImpl instance;
                injectedInstance = instance = InstanceImpl.forGlobalEntrypoint((Type)QuarkusComponentTestExtension.getFirstActualTypeArgument(requiredType), Set.of(qualifiers));
                this.unsetAction = () -> ((InstanceImpl)instance).destroy();
            } else if (QuarkusComponentTestExtension.isListAllInjectionPoint(requiredType, qualifiers, field)) {
                ArrayList unsetHandles = new ArrayList();
                injectedInstance = QuarkusComponentTestExtension.handleListAll(requiredType, qualifiers, container, unsetHandles);
                this.unsetAction = () -> this.destroyDependentHandles(unsetHandles);
            } else {
                InstanceHandle handle = container.instance(requiredType, qualifiers);
                InjectableBean bean = handle.getBean();
                if (isMock) {
                    if (!handle.isAvailable()) {
                        throw new IllegalStateException(String.format("The injected field [%s] expects a mocked bean; but obtained null", field));
                    }
                    if (bean.getKind() == InjectableBean.Kind.BUILTIN) {
                        if (!(bean instanceof EventBean)) {
                            throw new IllegalStateException("Only the jakarta.enterprise.event.Event built-in bean can be mocked: [%s]".formatted(field));
                        }
                    } else if (bean.getKind() != InjectableBean.Kind.SYNTHETIC) {
                        throw new IllegalStateException(String.format("The injected field [%s] expects a mocked bean; but obtained: %s", field, handle.getBean()));
                    }
                } else {
                    if (!handle.isAvailable()) {
                        throw new IllegalStateException(String.format("The injected field [%s] expects a real component; but no matching component was registered", field, handle.getBean()));
                    }
                    if (bean.getKind() == InjectableBean.Kind.SYNTHETIC) {
                        throw new IllegalStateException(String.format("The injected field [%s] expects a real component; but obtained: %s", field, handle.getBean()));
                    }
                }
                if (isMock && bean instanceof EventBean) {
                    Event mock = (Event)Mockito.mock(Event.class);
                    Object eventInstance = handle.get();
                    if (!(eventInstance instanceof Mockable)) {
                        throw new IllegalStateException("%s is not a Mockable Event implementation".formatted(eventInstance.getClass()));
                    }
                    Mockable mockable = (Mockable)eventInstance;
                    mockable.arc$setMock((Object)mock);
                    injectedInstance = mock;
                    this.unsetAction = () -> mockable.arc$clearMock();
                } else {
                    injectedInstance = handle.get();
                    this.unsetAction = () -> this.destroyDependentHandles(List.of(handle));
                }
            }
            if (!field.canAccess(testInstance)) {
                field.setAccessible(true);
            }
            field.set(testInstance, injectedInstance);
        }

        void unset() throws Exception {
            if (this.unsetAction != null) {
                this.unsetAction.run();
            }
            this.field.set(this.testInstance, null);
        }

        void destroyDependentHandles(List<InstanceHandle<?>> handles) {
            for (InstanceHandle<?> handle : handles) {
                if (handle.getBean() == null || !handle.getBean().getScope().equals(Dependent.class)) continue;
                try {
                    handle.destroy();
                }
                catch (Exception e) {
                    LOG.errorf((Throwable)e, "Unable to destroy the injected %s", (Object)handle.getBean());
                }
            }
        }
    }

    private static class AfterStopContextImpl
    extends ComponentTestContextImpl
    implements QuarkusComponentTestCallbacks.AfterStopContext {
        AfterStopContextImpl(Class<?> testClass) {
            super(testClass);
        }
    }

    private static class BeforeStartContextImpl
    extends ComponentTestContextImpl
    implements QuarkusComponentTestCallbacks.BeforeStartContext {
        private final Map<String, String> configProperties;

        BeforeStartContextImpl(Class<?> testClass, Map<String, String> existingProperties) {
            super(testClass);
            this.configProperties = new HashMap<String, String>(existingProperties);
        }

        @Override
        public void setConfigProperty(String key, String value) {
            this.configProperties.put(key, value);
        }
    }

    private static class AfterStartContextImpl
    extends ComponentTestContextImpl
    implements QuarkusComponentTestCallbacks.AfterStartContext {
        AfterStartContextImpl(Class<?> testClass) {
            super(testClass);
        }
    }

    static class ComponentTestContextImpl
    implements QuarkusComponentTestCallbacks.ComponentTestContext {
        private final Class<?> testClass;

        ComponentTestContextImpl(Class<?> testClass) {
            this.testClass = testClass;
        }

        @Override
        public Class<?> getTestClass() {
            return this.testClass;
        }
    }
}

