/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.test.component.ComponentClassLoader;
import io.quarkus.test.component.Conditions;
import io.quarkus.test.component.QuarkusComponentTestClassLoader;
import org.jboss.logging.Logger;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;

public class ComponentLauncherSessionListener
implements LauncherSessionListener {
    private static final Logger LOG = Logger.getLogger(ComponentLauncherSessionListener.class);
    private static ComponentClassLoader facadeLoader;
    private static ClassLoader oldCl;

    public void launcherSessionOpened(LauncherSession session) {
        if (Conditions.isFacadeLoaderUsed()) {
            return;
        }
        LOG.debugf("Set the ComponentFacadeLoader as TCCL", new Object[0]);
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if (currentCl == null || currentCl != facadeLoader && !currentCl.getClass().getName().equals(ComponentClassLoader.class.getName())) {
            oldCl = currentCl;
            if (facadeLoader == null) {
                facadeLoader = new ComponentClassLoader(currentCl);
            }
            Thread.currentThread().setContextClassLoader(facadeLoader);
        }
    }

    public void launcherSessionClosed(LauncherSession session) {
        if (oldCl != null) {
            LOG.debugf("Unset the ComponentFacadeLoader TCCL", new Object[0]);
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        QuarkusComponentTestClassLoader.BYTECODE_CACHE.clear();
    }

    static {
        oldCl = null;
    }
}

