/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxb.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.jaxb.deployment.utils.JaxbType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class FilteredJaxbClassesToBeBoundBuildItem
extends SimpleBuildItem {
    private final List<Class<?>> classes;

    public static Builder builder() {
        return new Builder();
    }

    private FilteredJaxbClassesToBeBoundBuildItem(List<Class<?>> classes) {
        this.classes = classes;
    }

    public List<Class<?>> getClasses() {
        return new ArrayList(this.classes);
    }

    private static Class<?> getClassByName(String name) {
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private final Set<String> classNames = new LinkedHashSet<String>();
        private final Set<Predicate<String>> classNamePredicateExcludes = new LinkedHashSet<Predicate<String>>();

        public Builder classNameExcludes(Collection<String> classNameExcludes) {
            String packMatch = ".*";
            for (String classNameExclude : classNameExcludes) {
                if (classNameExclude.endsWith(".*")) {
                    String packageName = classNameExclude.substring(0, classNameExclude.length() - ".*".length());
                    this.classNamePredicateExcludes.add(className -> className.startsWith(packageName));
                    continue;
                }
                this.classNamePredicateExcludes.add(classNameExclude::equals);
            }
            return this;
        }

        public Builder classNames(Collection<String> classNames) {
            for (String className : classNames) {
                this.classNames.add(className);
            }
            return this;
        }

        public FilteredJaxbClassesToBeBoundBuildItem build() {
            List<Class<?>> classes = this.classNames.stream().filter(className -> this.classNamePredicateExcludes.stream().noneMatch(p -> p.test(className))).map(FilteredJaxbClassesToBeBoundBuildItem::getClassByName).filter(JaxbType::isValidType).collect(Collectors.toList());
            return new FilteredJaxbClassesToBeBoundBuildItem(classes);
        }
    }
}

