/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSecurityProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.infinispan.client.InfinispanClientName;
import io.quarkus.infinispan.client.Remote;
import io.quarkus.infinispan.client.deployment.InfinispanClientBuildItem;
import io.quarkus.infinispan.client.deployment.InfinispanClientNameBuildItem;
import io.quarkus.infinispan.client.deployment.InfinispanPropertiesBuildItem;
import io.quarkus.infinispan.client.deployment.MarshallingBuildItem;
import io.quarkus.infinispan.client.runtime.InfinispanClientBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientProducer;
import io.quarkus.infinispan.client.runtime.InfinispanClientUtil;
import io.quarkus.infinispan.client.runtime.InfinispanClientsBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanRecorder;
import io.quarkus.infinispan.client.runtime.InfinispanServiceBindingConverter;
import io.quarkus.infinispan.client.runtime.cache.CacheInvalidateAllInterceptor;
import io.quarkus.infinispan.client.runtime.cache.CacheInvalidateInterceptor;
import io.quarkus.infinispan.client.runtime.cache.CacheResultInterceptor;
import io.quarkus.infinispan.client.runtime.cache.SynchronousInfinispanGet;
import io.quarkus.infinispan.client.runtime.graal.DisableLoggingFeature;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.schema.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

class InfinispanClientProcessor {
    private static final Log log = LogFactory.getLog(InfinispanClientProcessor.class);
    private static final String SERVICE_BINDING_INTERFACE_NAME = "io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter";
    private static final DotName INFINISPAN_CLIENT_ANNOTATION = DotName.createSimple((String)InfinispanClientName.class.getName());
    private static final DotName INFINISPAN_REMOTE_ANNOTATION = DotName.createSimple((String)Remote.class.getName());
    private static final DotName INFINISPAN_CLIENT = DotName.createSimple((String)RemoteCacheManager.class.getName());
    private static final DotName INFINISPAN_COUNTER_MANAGER = DotName.createSimple((String)CounterManager.class.getName());
    private static final DotName INFINISPAN_CACHE_CLIENT = DotName.createSimple((String)RemoteCache.class.getName());
    private static final String META_INF = "META-INF";
    private static final String DEFAULT_HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    private static final String PROTO_EXTENSION = ".proto";
    private static final String SASL_SECURITY_PROVIDER = "com.sun.security.sasl.Provider";
    private static final List<DotName> SUPPORTED_INJECTION_TYPE = List.of(INFINISPAN_CLIENT, INFINISPAN_COUNTER_MANAGER, INFINISPAN_CACHE_CLIENT);
    InfinispanClientsBuildTimeConfig infinispanClientsBuildTimeConfig;

    InfinispanClientProcessor() {
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(DisableLoggingFeature.class);
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.INFINISPAN_CLIENT);
    }

    @BuildStep
    public void handleProtoStreamRequirements(BuildProducer<MarshallingBuildItem> protostreamPropertiesBuildItem) throws ClassNotFoundException {
        Properties properties = new Properties();
        HashMap<String, Object> marshallers = new HashMap<String, Object>();
        InfinispanClientProcessor.initMarshaller("<default>", this.infinispanClientsBuildTimeConfig.defaultInfinispanClient().marshallerClass(), marshallers);
        for (String clientName : this.infinispanClientsBuildTimeConfig.getInfinispanNamedClientConfigNames()) {
            InfinispanClientProcessor.initMarshaller(clientName, this.infinispanClientsBuildTimeConfig.getInfinispanClientBuildTimeConfig(clientName).marshallerClass(), marshallers);
        }
        protostreamPropertiesBuildItem.produce((BuildItem)new MarshallingBuildItem(properties, marshallers));
    }

    private static void initMarshaller(String clientName, Optional<String> marshallerOpt, Map<String, Object> marshallers) throws ClassNotFoundException {
        if (marshallerOpt.isPresent()) {
            Class<?> marshallerClass = Class.forName(marshallerOpt.get(), false, Thread.currentThread().getContextClassLoader());
            marshallers.put(clientName, Util.getInstance(marshallerClass));
        } else {
            marshallers.put(clientName, new ProtoStreamMarshaller());
        }
    }

    @BuildStep
    InfinispanPropertiesBuildItem setup(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeployment, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<NativeImageSecurityProviderBuildItem> nativeImageSecurityProviders, BuildProducer<InfinispanClientNameBuildItem> infinispanClientNames, MarshallingBuildItem marshallingBuildItem, BuildProducer<NativeImageResourceBuildItem> resourceBuildItem, CombinedIndexBuildItem applicationIndexBuildItem) throws ClassNotFoundException, IOException {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(InfinispanClientProducer.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(CacheInvalidateAllInterceptor.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(CacheResultInterceptor.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(CacheInvalidateInterceptor.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SynchronousInfinispanGet.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(InfinispanClientName.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(Remote.class).build());
        resourceBuildItem.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"proto/generated/query.proto"}));
        resourceBuildItem.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"org/infinispan/protostream/message-wrapping.proto"}));
        hotDeployment.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF + File.separator + DEFAULT_HOTROD_CLIENT_PROPERTIES));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.INFINISPAN_CLIENT));
        nativeImageSecurityProviders.produce((BuildItem)new NativeImageSecurityProviderBuildItem(SASL_SECURITY_PROVIDER));
        this.handlePerCacheFileConfig(this.infinispanClientsBuildTimeConfig.defaultInfinispanClient(), resourceBuildItem, hotDeployment);
        for (InfinispanClientBuildTimeConfig config : this.infinispanClientsBuildTimeConfig.namedInfinispanClients().values()) {
            this.handlePerCacheFileConfig(config, resourceBuildItem, hotDeployment);
        }
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        IndexView index = applicationIndexBuildItem.getIndex();
        Set<String> allClientNames = this.infinispanClientNames(applicationIndexBuildItem, infinispanClientNames);
        allClientNames.addAll(this.infinispanClientsBuildTimeConfig.getInfinispanNamedClientConfigNames());
        allClientNames.add("<default>");
        for (String string : allClientNames) {
            Properties properties = this.loadHotrodProperties(string, reflectiveClass, marshallingBuildItem);
            propertiesMap.put(string, properties);
            Object marshaller = properties.get("infinispan.client.hotrod.marshaller");
            if (!(marshaller instanceof ProtoStreamMarshaller)) continue;
            for (ApplicationArchive applicationArchive : applicationArchivesBuildItem.getAllApplicationArchives()) {
                Path metaPath = applicationArchive.getChildPath(META_INF);
                if (metaPath == null) continue;
                Stream<Path> dirElements = Files.list(metaPath);
                try {
                    Iterator protoFiles = dirElements.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(PROTO_EXTENSION)).iterator();
                    if (protoFiles.hasNext()) {
                        // empty if block
                    }
                    while (protoFiles.hasNext()) {
                        Path path = (Path)protoFiles.next();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("  " + String.valueOf(path.toAbsolutePath())));
                        }
                        byte[] bytes = Files.readAllBytes(path);
                        properties.put("infinispan.client.hotrod.protofile." + path.getFileName().toString(), new String(bytes, StandardCharsets.UTF_8));
                    }
                }
                finally {
                    if (dirElements == null) continue;
                    dirElements.close();
                }
            }
            properties.putAll((Map<?, ?>)marshallingBuildItem.getProperties());
            Collection initializerClasses = index.getAllKnownImplementations(DotName.createSimple((String)SerializationContextInitializer.class.getName()));
            initializerClasses.addAll(index.getAllKnownImplementations(DotName.createSimple((String)GeneratedSchema.class.getName())));
            HashSet<SerializationContextInitializer> initializers = new HashSet<SerializationContextInitializer>(initializerClasses.size());
            for (ClassInfo ci : initializerClasses) {
                Class<?> initializerClass = Thread.currentThread().getContextClassLoader().loadClass(ci.toString());
                try {
                    SerializationContextInitializer sci = (SerializationContextInitializer)initializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    initializers.add(sci);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (initializers.isEmpty()) continue;
            properties.put("infinispan.client.hotrod.proto-initializers", initializers);
        }
        Collection listenerInstances = index.getAnnotations(DotName.createSimple((String)ClientListener.class.getName()));
        for (AnnotationInstance instance : listenerInstances) {
            AnnotationTarget target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{target.asClass().name().toString()}).methods().build());
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.infinispan.client.hotrod.event.impl.ContinuousQueryImpl$ClientEntryListener"}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.infinispan.client.hotrod.near.NearCacheService$InvalidatedNearCacheListener"}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash"}).build());
        String[] stringArray = new String[]{"org.wildfly.security.sasl.plain.PlainSaslClientFactory", "org.wildfly.security.sasl.scram.ScramSaslClientFactory", "org.wildfly.security.sasl.digest.DigestClientFactory", "org.wildfly.security.credential.BearerTokenCredential", "org.wildfly.security.credential.GSSKerberosCredential", "org.wildfly.security.credential.KeyPairCredential", "org.wildfly.security.credential.PasswordCredential", "org.wildfly.security.credential.PublicKeyCredential", "org.wildfly.security.credential.SecretKeyCredential", "org.wildfly.security.credential.SSHCredential", "org.wildfly.security.digest.SHA512_256MessageDigest", "org.wildfly.security.credential.X509CertificateChainPrivateCredential"};
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])stringArray).reason(this.getClass().getName()).build());
        return new InfinispanPropertiesBuildItem(propertiesMap);
    }

    private void handlePerCacheFileConfig(InfinispanClientBuildTimeConfig config, BuildProducer<NativeImageResourceBuildItem> resourceBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeployment) {
        for (InfinispanClientBuildTimeConfig.RemoteCacheConfig cacheConfig : config.cache().values()) {
            if (!cacheConfig.configurationResource().isPresent()) continue;
            resourceBuildItem.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{(String)cacheConfig.configurationResource().get()}));
            hotDeployment.produce((BuildItem)new HotDeploymentWatchedFileBuildItem((String)cacheConfig.configurationResource().get()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    BeanContainerListenerBuildItem build(InfinispanRecorder recorder, InfinispanPropertiesBuildItem builderBuildItem) {
        Map<String, Properties> propertiesMap = builderBuildItem.getProperties();
        this.addMaxEntries("<default>", this.infinispanClientsBuildTimeConfig.defaultInfinispanClient(), propertiesMap.get("<default>"));
        for (Map.Entry config : this.infinispanClientsBuildTimeConfig.namedInfinispanClients().entrySet()) {
            this.addMaxEntries((String)config.getKey(), (InfinispanClientBuildTimeConfig)config.getValue(), propertiesMap.get(config.getKey()));
        }
        return new BeanContainerListenerBuildItem(recorder.configureInfinispan(propertiesMap));
    }

    private static String getContents(String fileName) {
        InputStream stream = InfinispanClientProducer.class.getResourceAsStream(fileName);
        return InfinispanClientProcessor.getContents(stream);
    }

    private static String getContents(InputStream stream) {
        try (Scanner scanner = new Scanner(stream, StandardCharsets.UTF_8);){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    private Set<String> infinispanClientNames(CombinedIndexBuildItem indexBuildItem, BuildProducer<InfinispanClientNameBuildItem> infinispanClientNames) {
        HashSet<String> clientNames = new HashSet<String>();
        IndexView indexView = indexBuildItem.getIndex();
        Collection infinispanClientAnnotations = indexView.getAnnotations(INFINISPAN_CLIENT_ANNOTATION);
        for (AnnotationInstance annotation : infinispanClientAnnotations) {
            clientNames.add(annotation.value().asString());
        }
        if (this.infinispanClientsBuildTimeConfig.defaultInfinispanClient().devservices().devservices().enabled() && this.infinispanClientsBuildTimeConfig.defaultInfinispanClient().devservices().devservices().createDefaultClient()) {
            clientNames.add("<default>");
        }
        for (String clientName : clientNames) {
            infinispanClientNames.produce((BuildItem)new InfinispanClientNameBuildItem(clientName));
        }
        return clientNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadHotrodProperties(String clientName, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, MarshallingBuildItem marshallingBuildItem) {
        Object marshaller;
        Properties properties;
        Object filePath = InfinispanClientUtil.isDefault((String)clientName) ? "META-INF/hotrod-client.properties" : "META-INF/" + clientName + "-hotrod-client.properties";
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)filePath);
        if (stream == null) {
            properties = new Properties();
            if (log.isTraceEnabled()) {
                log.tracef("There was no %s file found - using defaults", filePath);
            }
        } else {
            try {
                properties = this.loadFromStream(stream);
                if (log.isDebugEnabled()) {
                    log.debugf("Found %s properties of %s", filePath, (Object)properties);
                }
            }
            finally {
                Util.close((AutoCloseable)stream);
            }
            if (properties.containsKey("infinispan.client.hotrod.near_cache.max_entries")) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.github.benmanes.caffeine.cache.SSMS"}).build());
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.github.benmanes.caffeine.cache.PSMS"}).build());
            }
        }
        if ((marshaller = marshallingBuildItem.getMarshallerForClientName(clientName)) == null) {
            marshaller = new ProtoStreamMarshaller();
        }
        properties.put("infinispan.client.hotrod.marshaller", marshaller);
        return properties;
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", (Throwable)e);
        }
        return properties;
    }

    private void addMaxEntries(String clientName, InfinispanClientBuildTimeConfig config, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debugf("Applying micro profile configuration: %s", (Object)config);
        }
        if (config.nearCacheMaxEntries() > 0 && !properties.containsKey("infinispan.client.hotrod.near_cache.mode") && InfinispanClientUtil.isDefault((String)clientName)) {
            properties.put("infinispan.client.hotrod.near_cache.mode", NearCacheMode.INVALIDATED.toString());
            properties.putIfAbsent("infinispan.client.hotrod.near_cache.max_entries", (Object)config.nearCacheMaxEntries());
        }
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{BaseMarshaller.class, EnumMarshaller.class, MessageMarshaller.class, FileDescriptorSource.class, Schema.class});
    }

    @BuildStep
    HealthBuildItem addHealthCheck(InfinispanClientsBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.infinispan.client.runtime.health.InfinispanHealthCheck", buildTimeConfig.healthEnabled());
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> buildProducer) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            buildProducer.produce((BuildItem)new ServiceProviderBuildItem(SERVICE_BINDING_INTERFACE_NAME, new String[]{InfinispanServiceBindingConverter.class.getName()}));
        }
    }

    @BuildStep
    InjectionPointTransformerBuildItem transformInjectionPoints() {
        return new InjectionPointTransformerBuildItem(new InjectionPointsTransformer(){

            public void transform(InjectionPointsTransformer.TransformationContext ctx) {
                AnnotationInstance cacheNameAnnotation = Annotations.find((Collection)ctx.getQualifiers(), (DotName)INFINISPAN_REMOTE_ANNOTATION);
                AnnotationInstance infinispanClientName = Annotations.find((Collection)ctx.getQualifiers(), (DotName)INFINISPAN_CLIENT_ANNOTATION);
                if (cacheNameAnnotation != null && infinispanClientName == null) {
                    ((InjectionPointsTransformer.Transformation)ctx.transform().add(INFINISPAN_CLIENT_ANNOTATION, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)"<default>")})).done();
                }
            }

            public boolean appliesTo(Type requiredType) {
                return requiredType.name().equals((Object)INFINISPAN_CACHE_CLIENT);
            }
        });
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateClientBeans(InfinispanRecorder recorder, BeanRegistrationPhaseBuildItem registrationPhase, BeanDiscoveryFinishedBuildItem finishedBuildItem, List<InfinispanClientNameBuildItem> infinispanClientNames, BeanDiscoveryFinishedBuildItem beans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        boolean createDefaultCacheManager;
        Set clientNames = infinispanClientNames.stream().map(icn -> icn.getName()).collect(Collectors.toSet());
        Set remoteCacheBeans = beans.getInjectionPoints().stream().filter(ip -> ip.getRequiredQualifier(INFINISPAN_REMOTE_ANNOTATION) != null).map(ip -> {
            AnnotationInstance remoteCacheQualifier = ip.getRequiredQualifier(INFINISPAN_REMOTE_ANNOTATION);
            AnnotationInstance clientNameQualifier = ip.getRequiredQualifier(INFINISPAN_CLIENT_ANNOTATION);
            RemoteCacheBean remoteCacheBean = new RemoteCacheBean();
            remoteCacheBean.type = ip.getType();
            remoteCacheBean.cacheName = remoteCacheQualifier.value().asString();
            remoteCacheBean.clientName = clientNameQualifier == null ? "<default>" : clientNameQualifier.value().asString();
            return remoteCacheBean;
        }).collect(Collectors.toSet());
        if (!clientNames.contains("<default>") && (createDefaultCacheManager = finishedBuildItem.getInjectionPoints().stream().filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name()) && i.getRequiredQualifier(INFINISPAN_CLIENT_ANNOTATION) == null).findAny().isPresent())) {
            clientNames.add("<default>");
        }
        for (String clientName : clientNames) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)InfinispanClientProcessor.configureAndCreateSyntheticBean(clientName, RemoteCacheManager.class, recorder.infinispanClientSupplier(clientName)));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)InfinispanClientProcessor.configureAndCreateSyntheticBean(clientName, CounterManager.class, recorder.infinispanCounterManagerSupplier(clientName)));
        }
        for (RemoteCacheBean remoteCacheBean : remoteCacheBeans) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)InfinispanClientProcessor.configureAndCreateSyntheticBean(remoteCacheBean, recorder.infinispanRemoteCacheClientSupplier(remoteCacheBean.clientName, remoteCacheBean.cacheName)));
        }
    }

    static <T> SyntheticBeanBuildItem configureAndCreateSyntheticBean(String name, Class<T> type, Supplier<T> supplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).supplier(supplier).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit();
        if (InfinispanClientUtil.isDefault((String)name)) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)name).done();
            configurator.addQualifier().annotation(INFINISPAN_CLIENT_ANNOTATION).addValue("value", (Object)name).done();
        }
        return configurator.done();
    }

    static <T> SyntheticBeanBuildItem configureAndCreateSyntheticBean(RemoteCacheBean remoteCacheBean, Supplier<T> supplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(RemoteCache.class).types(new Type[]{remoteCacheBean.type})).scope(ApplicationScoped.class)).supplier(supplier).unremovable()).setRuntimeInit();
        configurator.addQualifier().annotation(INFINISPAN_REMOTE_ANNOTATION).addValue("value", (Object)remoteCacheBean.cacheName).done();
        configurator.addQualifier().annotation(INFINISPAN_CLIENT_ANNOTATION).addValue("value", (Object)remoteCacheBean.clientName).done();
        return configurator.done();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    List<InfinispanClientBuildItem> infinispanClients(InfinispanRecorder recorder, List<InfinispanClientNameBuildItem> infinispanClientNames, BeanContainerBuildItem beanContainer) {
        ArrayList<InfinispanClientBuildItem> result = new ArrayList<InfinispanClientBuildItem>(infinispanClientNames.size());
        for (InfinispanClientNameBuildItem ic : infinispanClientNames) {
            String name = ic.getName();
            result.add(new InfinispanClientBuildItem((RuntimeValue<RemoteCacheManager>)recorder.getClient(name), name));
        }
        return result;
    }

    static class RemoteCacheBean {
        Type type;
        String clientName;
        String cacheName;

        RemoteCacheBean() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteCacheBean that = (RemoteCacheBean)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.clientName, that.clientName) && Objects.equals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.clientName, this.cacheName);
        }
    }
}

