/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.deployment.devui;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.infinispan.client.runtime.dev.ui.InfinispanClientsContainer;
import io.quarkus.infinispan.client.runtime.dev.ui.InfinispanJsonRPCService;
import org.infinispan.commons.util.Version;

public class InfinispanDevUIProcessor {
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public CardPageBuildItem infinispanServer() {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.setLogo("infinispan_dark.svg", "infinispan_light.svg");
        PageBuilder consoleLink = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Infinispan Server Console").dynamicUrlJsonRPCMethodName("getConsoleDefaultLink").doNotEmbed().icon("font-awesome-solid:server")).staticLabel(Version.getMajorMinor());
        cardPageBuildItem.addPage(consoleLink);
        ExternalPageBuilder documentation = ((ExternalPageBuilder)Page.externalPageBuilder((String)"Documentation").icon("font-awesome-solid:info")).url("https://infinispan.org/").doNotEmbed();
        cardPageBuildItem.addPage((PageBuilder)documentation);
        ExternalPageBuilder codeTutorials = ((ExternalPageBuilder)Page.externalPageBuilder((String)"Code Tutorials").icon("font-awesome-solid:hat-wizard")).url("https://github.com/infinispan/infinispan-simple-tutorials").doNotEmbed();
        cardPageBuildItem.addPage((PageBuilder)codeTutorials);
        return cardPageBuildItem;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(InfinispanJsonRPCService.class, BuiltinScope.SINGLETON.getName());
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.unremovableOf(InfinispanClientsContainer.class);
    }
}

