/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.deployment.devservices;

import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.infinispan.client.runtime.InfinispanClientBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientUtil;
import io.quarkus.infinispan.client.runtime.InfinispanClientsBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanDevServicesConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.core.InfinispanContainer;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class InfinispanDevServiceProcessor {
    private static final Logger log = Logger.getLogger(InfinispanDevServiceProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-infinispan";
    public static final int DEFAULT_INFINISPAN_PORT = 11222;
    private static final ContainerLocator infinispanContainerLocator = new ContainerLocator("quarkus-dev-service-infinispan", 11222);
    private static final String DEFAULT_PASSWORD = "password";
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";
    private static final String UNDERSCORE = "_";
    private static volatile Map<String, DevServicesResultBuildItem.RunningDevService> devServices;
    private static volatile Map<String, InfinispanClientBuildTimeConfig.DevServiceConfiguration> capturedDevServicesConfiguration;
    private static volatile boolean first;
    private static volatile Map<String, String> properties;

    @BuildStep
    public List<DevServicesResultBuildItem> startInfinispanContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, InfinispanClientsBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        if (devServices != null) {
            boolean restartRequired = false;
            for (String string : devServices.keySet()) {
                InfinispanClientBuildTimeConfig.DevServiceConfiguration devServiceConfig = capturedDevServicesConfiguration.get(string);
                restartRequired = restartRequired || !config.getInfinispanClientBuildTimeConfig((String)string).devService.equals((Object)devServiceConfig);
            }
            if (!restartRequired) {
                return devServices.values().stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices.values()) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop infinispan container", e);
                }
            }
            devServices = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = new HashMap<String, InfinispanClientBuildTimeConfig.DevServiceConfiguration>();
        HashMap<String, DevServicesResultBuildItem.RunningDevService> newDevServices = new HashMap<String, DevServicesResultBuildItem.RunningDevService>();
        capturedDevServicesConfiguration.put("<default>", config.defaultInfinispanClient.devService);
        for (Map.Entry entry : config.namedInfinispanClients.entrySet()) {
            capturedDevServicesConfiguration.put((String)entry.getKey(), ((InfinispanClientBuildTimeConfig)entry.getValue()).devService);
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Infinispan Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        this.runInfinispanDevService("<default>", launchMode, compressor, dockerStatusBuildItem, devServicesSharedNetworkBuildItem, config.defaultInfinispanClient, globalDevServicesConfig, newDevServices, properties);
        config.namedInfinispanClients.entrySet().forEach(dServ -> this.runInfinispanDevService((String)dServ.getKey(), launchMode, compressor, dockerStatusBuildItem, devServicesSharedNetworkBuildItem, (InfinispanClientBuildTimeConfig)dServ.getValue(), globalDevServicesConfig, newDevServices, properties));
        devServices = newDevServices;
        if (first) {
            first = false;
            Runnable runnable = () -> {
                if (devServices != null) {
                    for (Closeable closeable : devServices.values()) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop infinispan", t);
                        }
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(runnable, true);
        }
        return devServices.values().stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    private void runInfinispanDevService(String clientName, LaunchModeBuildItem launchMode, StartupLogCompressor compressor, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, InfinispanClientBuildTimeConfig config, GlobalDevServicesConfig globalDevServicesConfig, Map<String, DevServicesResultBuildItem.RunningDevService> newDevServices, Map<String, String> properties) {
        try {
            InfinispanDevServicesConfig namedDevServiceConfig = config.devService.devservices;
            DevServicesResultBuildItem.RunningDevService devService = this.startContainer(clientName, dockerStatusBuildItem, namedDevServiceConfig, launchMode.getLaunchMode(), !devServicesSharedNetworkBuildItem.isEmpty(), globalDevServicesConfig.timeout, properties);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
                return;
            }
            newDevServices.put(clientName, devService);
            log.infof("The infinispan server is ready to accept connections on %s", devService.getConfig().get(this.getConfigPrefix(clientName) + "hosts"));
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(String clientName, DockerStatusBuildItem dockerStatusBuildItem, InfinispanDevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout, Map<String, String> properties) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)"Not starting Dev Services for Infinispan as it has been disabled in the config");
            return null;
        }
        String configPrefix = this.getConfigPrefix(clientName);
        boolean bl = needToStart = !ConfigUtils.isPropertyNonEmpty((String)(configPrefix + "hosts")) && !ConfigUtils.isPropertyNonEmpty((String)(configPrefix + "server-list"));
        if (!needToStart) {
            log.debug((Object)"Not starting Dev Services for Infinispan as 'hosts', 'uri' or 'server-list' have been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Please configure 'quarkus.infinispan-client.hosts' or 'quarkus.infinispan-client.uri' or get a working Docker instance");
            return null;
        }
        log.infof("Starting Dev Services for connection %s", (Object)clientName);
        log.infof("Applying Dev Services config %s", (Object)devServicesConfig);
        Supplier<DevServicesResultBuildItem.RunningDevService> infinispanServerSupplier = () -> {
            QuarkusInfinispanContainer infinispanContainer = new QuarkusInfinispanContainer(clientName, devServicesConfig, launchMode, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((QuarkusInfinispanContainer)infinispanContainer).withStartupTimeout(arg_0));
            infinispanContainer.withEnv(devServicesConfig.containerEnv);
            infinispanContainer.start();
            return this.getRunningDevService(clientName, infinispanContainer.getContainerId(), () -> ((QuarkusInfinispanContainer)infinispanContainer).close(), infinispanContainer.getHost() + ":" + infinispanContainer.getPort(), infinispanContainer.getUser(), infinispanContainer.getPassword(), properties);
        };
        return infinispanContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> this.getRunningDevService(clientName, containerAddress.getId(), null, containerAddress.getUrl(), "admin", DEFAULT_PASSWORD, properties)).orElseGet(infinispanServerSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningDevService(String clientName, String containerId, Closeable closeable, String hosts, String username, String password, Map<String, String> config) {
        config.put(this.getConfigPrefix(clientName) + "hosts", hosts);
        config.put(this.getConfigPrefix(clientName) + "client-intelligence", ClientIntelligence.BASIC.name());
        config.put(this.getConfigPrefix(clientName) + "username", username);
        config.put(this.getConfigPrefix(clientName) + DEFAULT_PASSWORD, password);
        return new DevServicesResultBuildItem.RunningDevService(this.runningServiceName(clientName), containerId, closeable, config);
    }

    private String runningServiceName(String clientName) {
        if (InfinispanClientUtil.isDefault((String)clientName)) {
            return Feature.INFINISPAN_CLIENT.getName();
        }
        return Feature.INFINISPAN_CLIENT.getName() + UNDERSCORE + clientName;
    }

    private String getConfigPrefix(String name) {
        if (name.equals("<default>")) {
            return "quarkus.infinispan-client.";
        }
        return "quarkus.infinispan-client." + name + DOT;
    }

    static {
        first = true;
        properties = new HashMap<String, String>();
    }

    private static class QuarkusInfinispanContainer
    extends InfinispanContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusInfinispanContainer(String clientName, InfinispanDevServicesConfig config, LaunchMode launchMode, boolean useSharedNetwork) {
            super((String)((Object)config.imageName.orElse("quay.io/infinispan/server:" + Version.getUnbrandedVersion())));
            this.fixedExposedPort = config.port;
            this.useSharedNetwork = useSharedNetwork;
            if (launchMode == LaunchMode.DEVELOPMENT) {
                Object label = config.serviceName;
                if ("infinispan".equals(label) && !InfinispanClientUtil.isDefault((String)clientName)) {
                    label = (String)label + InfinispanDevServiceProcessor.UNDERSCORE + clientName;
                }
                this.withLabel(InfinispanDevServiceProcessor.DEV_SERVICE_LABEL, (String)label);
            }
            this.withUser("admin");
            this.withPassword(InfinispanDevServiceProcessor.DEFAULT_PASSWORD);
            Object command = "-c infinispan.xml";
            if (config.site.isPresent()) {
                command = "-c infinispan-xsite.xml -Dinfinispan.site.name=" + (String)config.site.get();
            }
            command = (String)command + config.configFiles.map(files -> files.stream().map(file -> {
                String userConfigFile = "/user-config/" + file;
                this.withClasspathResourceMapping((String)file, userConfigFile, BindMode.READ_ONLY);
                return " -c " + userConfigFile;
            }).collect(Collectors.joining())).orElse("");
            if (config.tracing.orElse(false).booleanValue()) {
                log.warn((Object)"Starting with Infinispan 15.0, Infinispan support for instrumentation of the server via OpenTelemetry has evolved. Enabling tracing by setting `quarkus.infinispan-client.devservices.tracing.enabled=true` doesn't work anymore.\nYou need to use the `quarkus.infinispan-client.devservices.tracing.enabled` property and provide a JSON, XML or YAML file as follows. Check https://quarkus.io/guides/infinispan-dev-services for more information");
                log.warn((Object)"infinispan:\n        cacheContainer:\n                tracing:\n                        collector-endpoint: \"http://jaeger:4318\"\n                        enabled: true\n                        exporter-protocol: \"OTLP\"\n                        service-name: \"infinispan-server\"\n                        security: false");
            }
            if (config.mcastPort.isPresent()) {
                command = (String)command + " -Djgroups.mcast_port=" + config.mcastPort.getAsInt();
            }
            config.artifacts.ifPresent(a -> this.withArtifacts(a.toArray(new String[0])));
            this.withCommand((String)command);
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"infinispan");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 11222);
            } else {
                this.addExposedPort(11222);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 11222;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getUser() {
            return "admin";
        }

        public String getPassword() {
            return InfinispanDevServiceProcessor.DEFAULT_PASSWORD;
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

