/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import org.hibernate.validator.path.RandomAccessPath;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.validation.ConstraintTypeUtil;

public class ConstraintTypeUtil20
implements ConstraintTypeUtil {
    public static final ConstraintTypeUtil INSTANCE = new ConstraintTypeUtil20();

    private ConstraintTypeUtil20() {
    }

    public ConstraintType.Type getConstraintType(Object o) {
        ConstraintViolation v;
        Path path;
        if (o instanceof ConstraintViolation && (path = (v = (ConstraintViolation)o).getPropertyPath()) instanceof RandomAccessPath) {
            RandomAccessPath randomAccessPath = (RandomAccessPath)path;
            switch (randomAccessPath.getRootNode().getKind()) {
                case BEAN: {
                    return ConstraintType.Type.CLASS;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    Path.Node secondNode = randomAccessPath.getNode(1);
                    if (secondNode.getKind() == ElementKind.PARAMETER || secondNode.getKind() == ElementKind.CROSS_PARAMETER) {
                        return ConstraintType.Type.PARAMETER;
                    }
                    if (secondNode.getKind() == ElementKind.RETURN_VALUE) {
                        return ConstraintType.Type.RETURN_VALUE;
                    }
                    throw new RuntimeException(Messages.MESSAGES.unexpectedPathNodeViolation(secondNode.getKind()));
                }
                case PROPERTY: {
                    return ConstraintType.Type.PROPERTY;
                }
            }
            throw new RuntimeException(Messages.MESSAGES.unexpectedPathNode(randomAccessPath.getRootNode().getKind()));
        }
        throw new RuntimeException(Messages.MESSAGES.unknownObjectPassedAsConstraintViolation(o));
    }
}

