/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Qualifier;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Qualifier
@Repeatable(value=List.class)
public @interface SearchExtension {
    public String backend() default "";

    public String index() default "";

    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public SearchExtension[] value();
    }

    public static class Literal
    extends AnnotationLiteral<SearchExtension>
    implements SearchExtension {
        private final String backend;
        private final String index;

        public Literal(String backend, String index) {
            this.backend = backend;
            this.index = index;
        }

        @Override
        public String backend() {
            return this.backend;
        }

        @Override
        public String index() {
            return this.index;
        }
    }
}

