/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.outboxpolling.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingBuildTimeConfig;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingRecorder;
import io.quarkus.hibernate.search.orm.outboxpolling.runtime.HibernateSearchOutboxPollingRuntimeConfig;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.spi.HibernateOrmMapperOutboxPollingClasses;

@BuildSteps(onlyIf={HibernateSearchEnabled.class})
class HibernateSearchOutboxPollingProcessor {
    private static final String HIBERNATE_SEARCH_ORM_COORDINATION_OUTBOX_POLLING = "Hibernate Search ORM - Outbox polling";

    HibernateSearchOutboxPollingProcessor() {
    }

    @BuildStep
    void registerInternalModel(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<AdditionalJpaModelBuildItem> additionalJpaModel) {
        String[] avroTypes = (String[])HibernateOrmMapperOutboxPollingClasses.avroTypes().toArray(String[]::new);
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(avroTypes));
        String[] hibernateOrmTypes = (String[])HibernateOrmMapperOutboxPollingClasses.hibernateOrmTypes().toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])hibernateOrmTypes).methods().fields().build());
        for (String className : hibernateOrmTypes) {
            additionalJpaModel.produce((BuildItem)new AdditionalJpaModelBuildItem(className));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setStaticConfig(HibernateSearchOutboxPollingRecorder recorder, HibernateSearchOutboxPollingBuildTimeConfig buildTimeConfig, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateSearchIntegrationStaticConfiguredBuildItem> staticConfigured) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            if (!this.isUsingOutboxPolling(configuredPersistenceUnit)) continue;
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            staticConfigured.produce((BuildItem)new HibernateSearchIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ORM_COORDINATION_OUTBOX_POLLING, puName, recorder.createStaticInitListener(buildTimeConfig, puName)).setXmlMappingRequired(true));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setRuntimeConfig(HibernateSearchOutboxPollingRecorder recorder, HibernateSearchOutboxPollingRuntimeConfig runtimeConfig, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateSearchIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            if (!this.isUsingOutboxPolling(configuredPersistenceUnit)) continue;
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            runtimeConfigured.produce((BuildItem)new HibernateSearchIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ORM_COORDINATION_OUTBOX_POLLING, puName, recorder.createRuntimeInitListener(runtimeConfig, puName)));
        }
    }

    private boolean isUsingOutboxPolling(HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem persistenceUnit) {
        HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit puConfig = persistenceUnit.getBuildTimeConfig();
        if (puConfig == null) {
            return false;
        }
        Optional configuredStrategy = puConfig.coordination().strategy();
        return configuredStrategy.isPresent() && ((String)configuredStrategy.get()).equals("outbox-polling");
    }
}

