/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.backend.elasticsearch.common.runtime;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.util.common.SearchException;

@ConfigGroup
public interface HibernateSearchBackendElasticsearchRuntimeConfig {
    @WithDefault(value="localhost:9200")
    public List<String> hosts();

    @WithDefault(value="http")
    public ElasticsearchClientProtocol protocol();

    public Optional<String> username();

    public Optional<String> password();

    @WithDefault(value="1S")
    public Duration connectionTimeout();

    @WithDefault(value="30S")
    public Duration readTimeout();

    public Optional<Duration> requestTimeout();

    @WithDefault(value="20")
    public int maxConnections();

    @WithDefault(value="10")
    public int maxConnectionsPerRoute();

    public DiscoveryConfig discovery();

    public ThreadPoolConfig threadPool();

    public QueryConfig query();

    public VersionCheckConfig versionCheck();

    @WithParentName
    public IndexConfig indexDefaults();

    @ConfigDocSection
    @ConfigDocMapKey(value="index-name")
    public Map<String, IndexConfig> indexes();

    public LayoutConfig layout();

    @ConfigGroup
    public static interface LayoutConfig {
        public Optional<String> strategy();
    }

    @ConfigGroup
    public static interface IndexingConfig {
        @ConfigDocDefault(value="10")
        public OptionalInt queueCount();

        @ConfigDocDefault(value="1000")
        public OptionalInt queueSize();

        @ConfigDocDefault(value="100")
        public OptionalInt maxBulkSize();
    }

    @ConfigGroup
    public static interface SchemaManagementConfig {
        @ConfigDocDefault(value="yellow")
        public Optional<IndexStatus> requiredStatus();

        @ConfigDocDefault(value="10S")
        public Optional<Duration> requiredStatusWaitTimeout();
    }

    @ConfigGroup
    public static interface QueryShardFailureConfig {
        @WithDefault(value="false")
        public boolean ignore();
    }

    @ConfigGroup
    public static interface QueryConfig {
        public QueryShardFailureConfig shardFailure();
    }

    @ConfigGroup
    public static interface ThreadPoolConfig {
        public OptionalInt size();
    }

    @ConfigGroup
    public static interface DiscoveryConfig {
        @WithDefault(value="false")
        public Boolean enabled();

        @WithDefault(value="10S")
        public Duration refreshInterval();
    }

    @ConfigGroup
    public static interface IndexConfig {
        public SchemaManagementConfig schemaManagement();

        public IndexingConfig indexing();
    }

    @ConfigGroup
    public static interface VersionCheckConfig {
        @WithDefault(value="true")
        public boolean enabled();
    }

    public static enum ElasticsearchClientProtocol {
        HTTP("http"),
        HTTPS("https");

        private final String hibernateSearchString;

        public static ElasticsearchClientProtocol of(String value) {
            return (ElasticsearchClientProtocol)((Object)ParseUtils.parseDiscreteValues((Object[])ElasticsearchClientProtocol.values(), ElasticsearchClientProtocol::getHibernateSearchString, (invalidValue, validValues) -> new SearchException(String.format(Locale.ROOT, "Invalid protocol: '%1$s'. Valid protocols are: %2$s.", invalidValue, validValues)), (String)value));
        }

        private ElasticsearchClientProtocol(String hibernateSearchString) {
            this.hibernateSearchString = hibernateSearchString;
        }

        public String getHibernateSearchString() {
            return this.hibernateSearchString;
        }
    }
}

