/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.customized;

import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.reactive.runtime.customized.QuarkusSqlClientPool;
import io.vertx.sqlclient.Pool;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class QuarkusReactiveConnectionPoolInitiator
implements StandardServiceInitiator<ReactiveConnectionPool> {
    private final Pool pool;

    public QuarkusReactiveConnectionPoolInitiator(Pool pool) {
        this.pool = pool;
    }

    public Class<ReactiveConnectionPool> getServiceInitiated() {
        return ReactiveConnectionPool.class;
    }

    public ReactiveConnectionPool initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        MultiTenancyStrategy strategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)configurationValues);
        if (strategy == MultiTenancyStrategy.DATABASE || strategy == MultiTenancyStrategy.SCHEMA) {
            return null;
        }
        return new QuarkusSqlClientPool(this.pool);
    }
}

