/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.boot.registry;

import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.boot.registry.MirroringIntegratorService;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusManagedBeanRegistryInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusJndiServiceInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusRuntimeProxyFactoryFactory;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusStrategySelectorBuilder;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.orm.runtime.service.CfgXmlAccessServiceInitiatorQuarkus;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import io.quarkus.hibernate.orm.runtime.service.QuarkusImportSqlCommandExtractorInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRegionFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRuntimeInitDialectFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRuntimeInitDialectResolverInitiator;
import io.quarkus.hibernate.orm.runtime.service.bytecodeprovider.QuarkusRuntimeBytecodeProviderInitiator;
import io.quarkus.hibernate.orm.runtime.service.internalcache.QuarkusInternalCacheFactoryInitiator;
import io.quarkus.hibernate.reactive.runtime.customized.CheckingVertxContextInitiator;
import io.quarkus.hibernate.reactive.runtime.customized.QuarkusNoJdbcConnectionProviderInitiator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.internal.ProxyFactoryFactoryInitiator;
import org.hibernate.engine.config.internal.ConfigurationServiceInitiator;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderInitiator;
import org.hibernate.engine.jdbc.connections.internal.MultiTenantConnectionProviderInitiator;
import org.hibernate.engine.jdbc.cursor.internal.RefCursorSupportInitiator;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.engine.jdbc.internal.SqlStatementLoggerInitiator;
import org.hibernate.event.internal.EntityCopyObserverFactoryInitiator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.persister.internal.PersisterFactoryInitiator;
import org.hibernate.property.access.internal.PropertyAccessStrategyResolverInitiator;
import org.hibernate.reactive.engine.jdbc.mutation.internal.ReactiveMutationExecutorServiceInitiator;
import org.hibernate.reactive.loader.ast.internal.ReactiveBatchLoaderFactoryInitiator;
import org.hibernate.reactive.provider.service.NativeParametersHandling;
import org.hibernate.reactive.provider.service.NoJdbcEnvironmentInitiator;
import org.hibernate.reactive.provider.service.NoJtaPlatformInitiator;
import org.hibernate.reactive.provider.service.ReactiveMarkerServiceInitiator;
import org.hibernate.reactive.provider.service.ReactivePersisterClassResolverInitiator;
import org.hibernate.reactive.provider.service.ReactiveSchemaManagementToolInitiator;
import org.hibernate.reactive.provider.service.ReactiveSessionFactoryBuilderInitiator;
import org.hibernate.reactive.provider.service.ReactiveSqmMultiTableMutationStrategyProviderInitiator;
import org.hibernate.reactive.provider.service.ReactiveValuesMappingProducerProviderInitiator;
import org.hibernate.resource.transaction.internal.TransactionCoordinatorBuilderInitiator;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.SessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.tool.schema.internal.SchemaManagementToolInitiator;

public class PreconfiguredReactiveServiceRegistryBuilder {
    private final Map configurationValues = new HashMap();
    private final List<StandardServiceInitiator<?>> initiators;
    private final List<ProvidedService<?>> providedServices = new ArrayList();
    private final Collection<Integrator> integrators;
    private final StandardServiceRegistryImpl destroyedRegistry;

    public PreconfiguredReactiveServiceRegistryBuilder(String puConfigName, RecordedState rs, HibernateOrmRuntimeConfigPersistenceUnit puConfig) {
        PreconfiguredReactiveServiceRegistryBuilder.checkIsReactive(rs);
        this.initiators = PreconfiguredReactiveServiceRegistryBuilder.buildQuarkusServiceInitiatorList(puConfigName, rs, puConfig);
        this.integrators = rs.getIntegrators();
        this.destroyedRegistry = (StandardServiceRegistryImpl)rs.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    private static void checkIsReactive(RecordedState rs) {
        if (!rs.isReactive()) {
            throw new IllegalStateException("Booting an Hibernate Reactive serviceregistry on a non-reactive RecordedState!");
        }
    }

    public PreconfiguredReactiveServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.configurationValues.put(settingName, value);
        return this;
    }

    public PreconfiguredReactiveServiceRegistryBuilder addInitiator(StandardServiceInitiator initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public PreconfiguredReactiveServiceRegistryBuilder addService(ProvidedService providedService) {
        this.providedServices.add(providedService);
        return this;
    }

    public StandardServiceRegistryImpl buildNewServiceRegistry() {
        BootstrapServiceRegistry bootstrapServiceRegistry = this.buildEmptyBootstrapServiceRegistry();
        HashMap settingsCopy = new HashMap();
        settingsCopy.putAll(this.configurationValues);
        this.destroyedRegistry.resetAndReactivate(bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
        return this.destroyedRegistry;
    }

    private BootstrapServiceRegistry buildEmptyBootstrapServiceRegistry() {
        ClassLoaderService providedClassLoaderService = FlatClassLoaderService.INSTANCE;
        StrategySelector strategySelector = QuarkusStrategySelectorBuilder.buildRuntimeSelector((ClassLoaderService)providedClassLoaderService);
        return new BootstrapServiceRegistryImpl(true, providedClassLoaderService, strategySelector, (IntegratorService)new MirroringIntegratorService(this.integrators));
    }

    private static List<StandardServiceInitiator<?>> buildQuarkusServiceInitiatorList(String puConfigName, RecordedState rs, HibernateOrmRuntimeConfigPersistenceUnit puConfig) {
        ArrayList serviceInitiators = new ArrayList();
        QuarkusRuntimeProxyFactoryFactory preGeneratedProxyFactory = new QuarkusRuntimeProxyFactoryFactory(rs.getProxyClassDefinitions());
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveMarkerServiceInitiator.INSTANCE);
        serviceInitiators.add(CheckingVertxContextInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveSessionFactoryBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)new QuarkusRuntimeBytecodeProviderInitiator(preGeneratedProxyFactory));
        serviceInitiators.add(ProxyFactoryFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveMutationExecutorServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)CfgXmlAccessServiceInitiatorQuarkus.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ConfigurationServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)PropertyAccessStrategyResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)QuarkusImportSqlCommandExtractorInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SchemaManagementToolInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)NoJdbcEnvironmentInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)QuarkusJndiServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactivePersisterClassResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)PersisterFactoryInitiator.INSTANCE);
        serviceInitiators.add(QuarkusNoJdbcConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)MultiTenantConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)new QuarkusRuntimeInitDialectResolverInitiator(rs.getDialect()));
        serviceInitiators.add((StandardServiceInitiator<?>)new QuarkusRuntimeInitDialectFactoryInitiator(puConfigName, rs.isFromPersistenceXml(), rs.getDialect(), rs.getBuildTimeSettings().getSource(), puConfig));
        serviceInitiators.add((StandardServiceInitiator<?>)BatchBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)JdbcServicesInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)RefCursorSupportInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveSchemaManagementToolInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)NoJtaPlatformInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)QuarkusRegionFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)TransactionCoordinatorBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)QuarkusManagedBeanRegistryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)EntityCopyObserverFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveValuesMappingProducerProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveSqmMultiTableMutationStrategyProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)NativeParametersHandling.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SqlStatementLoggerInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ReactiveBatchLoaderFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)QuarkusInternalCacheFactoryInitiator.INSTANCE);
        serviceInitiators.trimToSize();
        return serviceInitiators;
    }
}

