/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.reactive.runtime.HibernateReactive;
import io.quarkus.hibernate.reactive.runtime.ReactivePersistenceProviderSetup;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.SessionFactory;
import org.hibernate.reactive.mutiny.Mutiny;

@Recorder
public class HibernateReactiveRecorder {
    private final RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig;

    public HibernateReactiveRecorder(RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void callHibernateReactiveFeatureInit(boolean enabled) {
        HibernateReactive.featureInit(enabled);
    }

    public void initializePersistenceProvider(Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        ReactivePersistenceProviderSetup.registerRuntimePersistenceProvider((HibernateOrmRuntimeConfig)this.runtimeConfig.getValue(), integrationRuntimeDescriptors);
    }

    public Supplier<ActiveResult> checkActiveSupplier(final String puName, final Optional<String> dataSourceName, final Set<String> entityClassNames) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                InjectableBean dataSourceBean;
                ActiveResult dataSourceActive;
                Optional active = ((HibernateOrmRuntimeConfigPersistenceUnit)((HibernateOrmRuntimeConfig)HibernateReactiveRecorder.this.runtimeConfig.getValue()).persistenceUnits().get(puName)).active();
                if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
                    return ActiveResult.inactive((String)PersistenceUnitUtil.persistenceUnitInactiveReasonDeactivated((String)puName, (Optional)dataSourceName));
                }
                if (entityClassNames.isEmpty() && dataSourceName.isPresent() && !(dataSourceActive = (dataSourceBean = ReactiveDataSourceUtil.dataSourceInstance((String)((String)dataSourceName.get())).getHandle().getBean()).checkActive()).value()) {
                    return ActiveResult.inactive((String)String.format(Locale.ROOT, "Persistence unit '%s' was deactivated automatically because it doesn't include any entity type and its datasource '%s' was deactivated.", puName, dataSourceName.get()), (ActiveResult)dataSourceActive);
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<Mutiny.SessionFactory>, Mutiny.SessionFactory> mutinySessionFactory(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<Mutiny.SessionFactory>, Mutiny.SessionFactory>(){

            @Override
            public Mutiny.SessionFactory apply(SyntheticCreationalContext<Mutiny.SessionFactory> context) {
                JPAConfig jpaConfig = (JPAConfig)context.getInjectedReference(JPAConfig.class, new Annotation[0]);
                SessionFactory sessionFactory = (SessionFactory)jpaConfig.getEntityManagerFactory(persistenceUnitName, true).unwrap(SessionFactory.class);
                return (Mutiny.SessionFactory)sessionFactory.unwrap(Mutiny.SessionFactory.class);
            }
        };
    }
}

