/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.MultiplePersistenceProviderResolver;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.reactive.runtime.FastBootHibernateReactivePersistenceProvider;
import io.quarkus.hibernate.reactive.runtime.StaticInitHibernateReactivePersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import java.util.List;
import java.util.Map;

public final class ReactivePersistenceProviderSetup {
    private ReactivePersistenceProviderSetup() {
    }

    public static void registerStaticInitPersistenceProvider() {
        PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)new StaticInitHibernateReactivePersistenceProviderResolver());
    }

    public static void registerRuntimePersistenceProvider(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        PersistenceProviderResolver persistenceProviderResolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        if (persistenceProviderResolver == null || persistenceProviderResolver != null && !(persistenceProviderResolver instanceof MultiplePersistenceProviderResolver)) {
            persistenceProviderResolver = new MultiplePersistenceProviderResolver(new PersistenceProvider[0]);
            PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)persistenceProviderResolver);
        }
        ((MultiplePersistenceProviderResolver)persistenceProviderResolver).addPersistenceProvider((PersistenceProvider)new FastBootHibernateReactivePersistenceProvider(hibernateOrmRuntimeConfig, integrationRuntimeDescriptors));
    }
}

