/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.reactive.runtime.HibernateReactive;
import io.quarkus.hibernate.reactive.runtime.ReactivePersistenceProviderSetup;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.hibernate.reactive.mutiny.Mutiny;

@Recorder
public class HibernateReactiveRecorder {
    private final RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig;

    public HibernateReactiveRecorder(RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void callHibernateReactiveFeatureInit(boolean enabled) {
        HibernateReactive.featureInit(enabled);
    }

    public void initializePersistenceProvider(Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        ReactivePersistenceProviderSetup.registerRuntimePersistenceProvider((HibernateOrmRuntimeConfig)this.runtimeConfig.getValue(), integrationRuntimeDescriptors);
    }

    public Function<SyntheticCreationalContext<Mutiny.SessionFactory>, Mutiny.SessionFactory> mutinySessionFactory(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<Mutiny.SessionFactory>, Mutiny.SessionFactory>(){

            @Override
            public Mutiny.SessionFactory apply(SyntheticCreationalContext<Mutiny.SessionFactory> context) {
                JPAConfig jpaConfig = (JPAConfig)context.getInjectedReference(JPAConfig.class, new Annotation[0]);
                if (jpaConfig.getDeactivatedPersistenceUnitNames().contains("default-reactive")) {
                    throw new IllegalStateException("Cannot retrieve the Mutiny.SessionFactory for persistence unit default-reactive: Hibernate Reactive was deactivated through configuration properties");
                }
                SessionFactory sessionFactory = (SessionFactory)jpaConfig.getEntityManagerFactory(persistenceUnitName).unwrap(SessionFactory.class);
                return (Mutiny.SessionFactory)sessionFactory.unwrap(Mutiny.SessionFactory.class);
            }
        };
    }
}

