/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.kotlin;

import io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations;
import io.quarkus.hibernate.reactive.panache.kotlin.runtime.KotlinJpaOperations;
import io.quarkus.panache.common.Parameters;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.reactive.mutiny.Mutiny;

public class Panache {
    public static <T> Uni<T> withSession(Supplier<Uni<T>> uniSupplier) {
        return SessionOperations.withSession((String)"<default>", (T s) -> (Uni)uniSupplier.get());
    }

    public static <T> Uni<T> withSession(String persistenceUnitName, Supplier<Uni<T>> uniSupplier) {
        return SessionOperations.withSession((String)persistenceUnitName, (T s) -> (Uni)uniSupplier.get());
    }

    public static Uni<Mutiny.Session> getSession() {
        return SessionOperations.getSession();
    }

    public static <T> Uni<T> withTransaction(Supplier<Uni<T>> work) {
        return Panache.withTransaction("<default>", work);
    }

    public static <T> Uni<T> withTransaction(String persistenceUnitName, Supplier<Uni<T>> work) {
        return SessionOperations.withTransaction((String)persistenceUnitName, () -> (Uni)work.get());
    }

    public static Uni<Integer> executeUpdate(String query, Object ... params) {
        return KotlinJpaOperations.INSTANCE.executeUpdate(query, params);
    }

    public static Uni<Integer> executeUpdate(String query, Map<String, Object> params) {
        return KotlinJpaOperations.INSTANCE.executeUpdate(query, params);
    }

    public static Uni<Integer> executeUpdate(String query, Parameters params) {
        return KotlinJpaOperations.INSTANCE.executeUpdate(query, params.map());
    }

    public static Uni<Void> flush() {
        return Panache.getSession().flatMap(session -> session.flush());
    }

    public static Uni<Mutiny.Transaction> currentTransaction() {
        return Panache.getSession().map(session -> session.currentTransaction());
    }
}

