/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.kotlin.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.reactive.panache.kotlin.deployment.ReactiveKotlinJpaTypeBundle;
import io.quarkus.panache.common.deployment.KotlinPanacheCompanionEnhancer;
import io.quarkus.panache.common.deployment.KotlinPanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.KotlinPanacheRepositoryEnhancer;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.hibernate.common.deployment.HibernateEnhancersRegisteredBuildItem;
import jakarta.persistence.Id;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.hibernate.reactive.mutiny.Mutiny;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class HibernateReactivePanacheKotlinProcessor {
    private static final DotName DOTNAME_REACTIVE_SESSION = DotName.createSimple((String)Mutiny.Session.class.getName());
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());
    private static final TypeBundle TYPE_BUNDLE = ReactiveKotlinJpaTypeBundle.BUNDLE;

    @BuildStep
    public FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_REACTIVE_PANACHE_KOTLIN);
    }

    @BuildStep
    public AdditionalJpaModelBuildItem produceModel() {
        return new AdditionalJpaModelBuildItem("io.quarkus.hibernate.reactive.panache.kotlin.PanacheEntity");
    }

    @BuildStep
    public UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DOTNAME_REACTIVE_SESSION});
    }

    @BuildStep
    @Consume(value=HibernateEnhancersRegisteredBuildItem.class)
    public void build(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        this.processRepositories(index, transformers, reflectiveClass, (PanacheRepositoryEnhancer)new KotlinPanacheRepositoryEnhancer(index.getComputingIndex(), methodCustomizers, TYPE_BUNDLE));
        this.processEntities(index, transformers, reflectiveClass, (PanacheEntityEnhancer)new KotlinPanacheEntityEnhancer(index.getComputingIndex(), methodCustomizers, TYPE_BUNDLE));
        this.processCompanions(index, transformers, reflectiveClass, new KotlinPanacheCompanionEnhancer(index.getComputingIndex(), methodCustomizers, TYPE_BUNDLE));
    }

    private void processEntities(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, PanacheEntityEnhancer entityEnhancer) {
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownImplementors(TYPE_BUNDLE.entityBase().dotName())) {
            String name;
            if (classInfo.name().equals((Object)TYPE_BUNDLE.entity().dotName()) || !modelClasses.add(name = classInfo.name().toString())) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(name, (BiFunction)entityEnhancer));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{name}));
        }
    }

    private void processCompanions(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, KotlinPanacheCompanionEnhancer enhancer) {
        HashSet typeParameters = new HashSet();
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownImplementors(TYPE_BUNDLE.entityCompanionBase().dotName())) {
            if (classInfo.name().equals((Object)TYPE_BUNDLE.entityCompanion().dotName())) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
            typeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)TYPE_BUNDLE.entityCompanionBase().dotName(), (IndexView)index.getComputingIndex()));
        }
        for (Type parameterType : typeParameters) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{parameterType.name().toString()}));
        }
    }

    private void processRepositories(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, PanacheRepositoryEnhancer enhancer) {
        HashSet typeParameters = new HashSet();
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownImplementors(TYPE_BUNDLE.repositoryBase().dotName())) {
            if (classInfo.name().equals((Object)TYPE_BUNDLE.repository().dotName()) || enhancer.skipRepository(classInfo)) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
            typeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)TYPE_BUNDLE.repositoryBase().dotName(), (IndexView)index.getComputingIndex()));
        }
        for (Type parameterType : typeParameters) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{parameterType.name().toString()}));
        }
    }

    @BuildStep
    public ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getComputingIndex().getAnnotations(DOTNAME_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (!JandexUtil.isSubclassOf((IndexView)index.getComputingIndex(), (ClassInfo)info, (DotName)TYPE_BUNDLE.entity().dotName())) continue;
            BuildException be = new BuildException("You provide a JPA identifier via @Id inside '" + String.valueOf(info.name()) + "' but one is already provided by PanacheEntity, your class should extend PanacheEntityBase instead, or use the id provided by PanacheEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }
}

