/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.reactive.common.spi.Implementor;
import org.hibernate.reactive.context.Context;
import org.hibernate.reactive.context.impl.BaseKey;
import org.hibernate.reactive.mutiny.Mutiny;

public final class SessionOperations {
    private static final String ERROR_MSG = "Hibernate Reactive Panache requires a safe (isolated) Vert.x sub-context, but the current context hasn't been flagged as such.";
    private static final ComputingCache<String, Context.Key<Mutiny.Session>> SESSION_KEY_MAP = new ComputingCache(k -> SessionOperations.createSessionKey(k));
    private static final ComputingCache<String, Mutiny.SessionFactory> SESSION_FACTORY_MAP = new ComputingCache(k -> SessionOperations.createSessionFactory(k));
    private static final String SESSION_ON_DEMAND_KEY = "hibernate.reactive.panache.sessionOnDemand";
    private static final String SESSION_ON_DEMAND_OPENED_KEY = "hibernate.reactive.panache.sessionOnDemandOpened";

    private static Mutiny.SessionFactory createSessionFactory(String persistenceunitname) {
        Mutiny.SessionFactory sessionFactory = "<default>".equals(persistenceunitname) ? (Mutiny.SessionFactory)Arc.container().instance(Mutiny.SessionFactory.class, new Annotation[0]).get() : (Mutiny.SessionFactory)Arc.container().instance(Mutiny.SessionFactory.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistenceunitname)}).get();
        if (sessionFactory == null) {
            throw new IllegalStateException("Mutiny.SessionFactory bean not found");
        }
        return sessionFactory;
    }

    private static Context.Key<Mutiny.Session> createSessionKey(String persistenceUnitName) {
        Implementor implementor = (Implementor)ClientProxy.unwrap((Object)((Mutiny.SessionFactory)SESSION_FACTORY_MAP.getValue((Object)persistenceUnitName)));
        return new BaseKey(Mutiny.Session.class, implementor.getUuid());
    }

    static <T> Uni<T> withSessionOnDemand(Supplier<Uni<T>> work) {
        Context context = SessionOperations.vertxContext();
        if (context.getLocal((Object)SESSION_ON_DEMAND_KEY) != null) {
            return work.get();
        }
        context.putLocal((Object)SESSION_ON_DEMAND_KEY, (Object)true);
        return work.get().eventually(() -> {
            context.removeLocal((Object)SESSION_ON_DEMAND_KEY);
            Set onDemandSessionCreated = (Set)context.getLocal((Object)SESSION_ON_DEMAND_OPENED_KEY);
            if (onDemandSessionCreated != null) {
                ArrayList<Uni<Void>> closedSessions = new ArrayList<Uni<Void>>();
                for (String s : onDemandSessionCreated) {
                    closedSessions.add(SessionOperations.closeSession(s));
                }
                context.removeLocal((Object)SESSION_ON_DEMAND_OPENED_KEY);
                return Uni.combine().all().unis(closedSessions).discardItems();
            }
            return Uni.createFrom().voidItem();
        });
    }

    public static <T> Uni<T> withTransaction(Supplier<Uni<T>> work) {
        return SessionOperations.withSession("<default>", s -> s.withTransaction(arg_0 -> SessionOperations.lambda$withTransaction$3((Supplier)work, arg_0)));
    }

    public static <T> Uni<T> withTransaction(String persistenceUnitName, Supplier<Uni<T>> work) {
        return SessionOperations.withSession(persistenceUnitName, s -> s.withTransaction(arg_0 -> SessionOperations.lambda$withTransaction$5((Supplier)work, arg_0)));
    }

    public static <T> Uni<T> withTransaction(Function<Mutiny.Transaction, Uni<T>> work) {
        return SessionOperations.withSession("<default>", s -> s.withTransaction(work));
    }

    public static <T> Uni<T> withSession(String persistenceUnitName, Function<Mutiny.Session, Uni<T>> work) {
        Context.Key key;
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal((Object)(key = (Context.Key)SESSION_KEY_MAP.getValue((Object)persistenceUnitName)));
        if (current != null && current.isOpen()) {
            return work.apply(current);
        }
        return ((Mutiny.SessionFactory)SESSION_FACTORY_MAP.getValue((Object)persistenceUnitName)).openSession().invoke(s -> context.putLocal((Object)key, s)).chain(work::apply).eventually(() -> SessionOperations.closeSession(persistenceUnitName));
    }

    public static <T> Uni<T> withSession(Function<Mutiny.Session, Uni<T>> work) {
        return SessionOperations.withSession("<default>", work);
    }

    public static Uni<Mutiny.Session> getSession() {
        return SessionOperations.getSession("<default>");
    }

    public static Uni<Mutiny.Session> getSession(String persistenceUnitName) {
        Context.Key key;
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal((Object)(key = (Context.Key)SESSION_KEY_MAP.getValue((Object)persistenceUnitName)));
        if (current != null && current.isOpen()) {
            return Uni.createFrom().item((Object)current);
        }
        if (context.getLocal((Object)SESSION_ON_DEMAND_KEY) != null) {
            HashSet<String> onDemandSessionsCreated = (HashSet<String>)context.getLocal((Object)SESSION_ON_DEMAND_OPENED_KEY);
            if (onDemandSessionsCreated == null) {
                onDemandSessionsCreated = new HashSet<String>();
                context.putLocal((Object)SESSION_ON_DEMAND_OPENED_KEY, onDemandSessionsCreated);
            }
            if (onDemandSessionsCreated.contains(persistenceUnitName)) {
                return Uni.createFrom().item(() -> SessionOperations.getCurrentSession(persistenceUnitName));
            }
            onDemandSessionsCreated.add(persistenceUnitName);
            return ((Mutiny.SessionFactory)SESSION_FACTORY_MAP.getValue((Object)persistenceUnitName)).openSession().invoke(s -> context.putLocal((Object)key, s));
        }
        throw new IllegalStateException("No current Mutiny.Session found\n\t- no reactive session was found in the Vert.x context and the context was not marked to open a new session lazily\n\t- a session is opened automatically for JAX-RS resource methods annotated with an HTTP method (@GET, @POST, etc.); inherited annotations are not taken into account\n\t- you may need to annotate the business method with @WithSession or @WithTransaction");
    }

    public static Mutiny.Session getCurrentSession(String persistenceUnitName) {
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal(SESSION_KEY_MAP.getValue((Object)persistenceUnitName));
        if (current != null && current.isOpen()) {
            return current;
        }
        return null;
    }

    private static Context vertxContext() {
        Context context = Vertx.currentContext();
        if (context != null) {
            VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
            return context;
        }
        throw new IllegalStateException("No current Vertx context found");
    }

    static Uni<Void> closeSession(String persistenceUnitName) {
        Context.Key key;
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal((Object)(key = (Context.Key)SESSION_KEY_MAP.getValue((Object)persistenceUnitName)));
        if (current != null && current.isOpen()) {
            return current.close().eventually(() -> context.removeLocal((Object)key));
        }
        return Uni.createFrom().voidItem();
    }

    static void clear() {
        SESSION_FACTORY_MAP.clear();
        SESSION_KEY_MAP.clear();
    }

    private static /* synthetic */ Uni lambda$withTransaction$5(Supplier work, Mutiny.Transaction t) {
        return (Uni)work.get();
    }

    private static /* synthetic */ Uni lambda$withTransaction$3(Supplier work, Mutiny.Transaction t) {
        return (Uni)work.get();
    }
}

