/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.hibernate.reactive.panache.common.WithTransaction;
import io.quarkus.hibernate.reactive.panache.common.runtime.AbstractUniInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;

@WithTransaction
@Interceptor
@Priority(value=200)
public class WithTransactionInterceptor
extends AbstractUniInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        if (this.isUniReturnType(context)) {
            String persistenceUnitName = this.getPersistenceUnitName(context);
            return SessionOperations.withTransaction(persistenceUnitName, () -> this.proceedUni(context));
        }
        return context.proceed();
    }

    private String getPersistenceUnitName(InvocationContext context) {
        WithTransaction annotation = context.getMethod().getAnnotation(WithTransaction.class);
        if (annotation == null) {
            annotation = context.getTarget().getClass().getAnnotation(WithTransaction.class);
        }
        return annotation.value();
    }
}

