/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.reactive.panache.common.deployment.DotNames;
import io.quarkus.hibernate.reactive.panache.common.deployment.PanacheNamedQueryEntityClassBuildStep;
import io.quarkus.hibernate.reactive.panache.common.runtime.PanacheHibernateRecorder;
import io.quarkus.hibernate.reactive.panache.common.runtime.ReactiveTransactionalInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.TestReactiveTransactionalInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.WithSessionInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.WithSessionOnDemandInterceptor;
import io.quarkus.hibernate.reactive.panache.common.runtime.WithTransactionInterceptor;
import io.quarkus.runtime.ShutdownContext;
import jakarta.annotation.Priority;
import jakarta.interceptor.Interceptor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class PanacheJpaCommonResourceProcessor {
    private static final Logger LOG = Logger.getLogger(PanacheJpaCommonResourceProcessor.class);
    private static final String TEST_REACTIVE_TRANSACTION = "io.quarkus.test.TestReactiveTransaction";

    @BuildStep(onlyIf={IsTest.class})
    void testTx(BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (!PanacheJpaCommonResourceProcessor.testReactiveTransactionOnClassPath()) {
            return;
        }
        try (ClassCreator c = ClassCreator.builder().classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer)).className(TestReactiveTransactionalInterceptor.class.getName() + "Generated").superClass(TestReactiveTransactionalInterceptor.class).build();){
            c.addAnnotation(TEST_REACTIVE_TRANSACTION);
            c.addAnnotation(Interceptor.class.getName());
            c.addAnnotation(Priority.class).addValue("value", (Object)200);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(TestReactiveTransactionalInterceptor.class).addBeanClass(TEST_REACTIVE_TRANSACTION).build());
    }

    private static boolean testReactiveTransactionOnClassPath() {
        try {
            Class.forName(TEST_REACTIVE_TRANSACTION, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @BuildStep
    void registerInterceptors(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        builder.addBeanClass(WithSessionOnDemandInterceptor.class);
        builder.addBeanClass(WithSessionInterceptor.class);
        builder.addBeanClass(ReactiveTransactionalInterceptor.class);
        builder.addBeanClass(WithTransactionInterceptor.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep
    void validateInterceptedMethods(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        List<DotName> bindings = List.of(DotNames.REACTIVE_TRANSACTIONAL, DotNames.WITH_SESSION, DotNames.WITH_SESSION_ON_DEMAND, DotNames.WITH_TRANSACTION);
        for (BeanInfo bean : validationPhase.getContext().beans().withAroundInvokeInterceptor()) {
            for (Map.Entry<MethodInfo, Set<AnnotationInstance>> entry : bean.getInterceptedMethodsBindings().entrySet()) {
                DotName returnTypeName = ((MethodInfo)entry.getKey()).returnType().name();
                if (returnTypeName.equals((Object)DotNames.UNI)) continue;
                this.validateBindings(bindings, entry, errors);
            }
        }
    }

    @BuildStep
    void transformResourceMethods(CombinedIndexBuildItem index, Capabilities capabilities, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            final List<DotName> designators = List.of(DotName.createSimple((String)"jakarta.ws.rs.GET"), DotName.createSimple((String)"jakarta.ws.rs.HEAD"), DotName.createSimple((String)"jakarta.ws.rs.DELETE"), DotName.createSimple((String)"jakarta.ws.rs.OPTIONS"), DotName.createSimple((String)"jakarta.ws.rs.PATCH"), DotName.createSimple((String)"jakarta.ws.rs.POST"), DotName.createSimple((String)"jakarta.ws.rs.PUT"));
            final List<DotName> bindings = List.of(DotNames.REACTIVE_TRANSACTIONAL, DotNames.WITH_SESSION, DotNames.WITH_SESSION_ON_DEMAND, DotNames.WITH_TRANSACTION);
            HashSet<DotName> entities = new HashSet<DotName>();
            for (ClassInfo subclass : index.getIndex().getAllKnownSubclasses(DotNames.PANACHE_ENTITY_BASE)) {
                if (subclass.name().equals((Object)DotNames.PANACHE_ENTITY)) continue;
                entities.add(subclass.name());
            }
            for (Object implementor : index.getIndex().getAllKnownImplementors(DotNames.PANACHE_KOTLIN_ENTITY_BASE)) {
                if (implementor.name().equals((Object)DotNames.PANACHE_KOTLIN_ENTITY)) continue;
                entities.add(implementor.name());
            }
            HashSet<DotName> repos = new HashSet<DotName>();
            for (ClassInfo subclass : index.getIndex().getAllKnownImplementors(DotNames.PANACHE_REPOSITORY_BASE)) {
                if (subclass.name().equals((Object)DotNames.PANACHE_REPOSITORY)) continue;
                repos.add(subclass.name());
            }
            for (ClassInfo implementor : index.getIndex().getAllKnownImplementors(DotNames.PANACHE_KOTLIN_REPOSITORY_BASE)) {
                if (implementor.name().equals((Object)DotNames.PANACHE_KOTLIN_REPOSITORY)) continue;
                repos.add(implementor.name());
            }
            final HashSet<DotName> entityReposUsers = new HashSet<DotName>();
            for (DotName entity : entities) {
                for (ClassInfo user : index.getIndex().getKnownUsers(entity)) {
                    entityReposUsers.add(user.name());
                }
            }
            for (DotName repo : repos) {
                for (ClassInfo user : index.getIndex().getKnownUsers(repo)) {
                    entityReposUsers.add(user.name());
                }
            }
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.METHOD;
                }

                public void transform(AnnotationsTransformer.TransformationContext context) {
                    MethodInfo method = context.getTarget().asMethod();
                    Collection annotations = context.getAnnotations();
                    if (method.isSynthetic() || Modifier.isStatic(method.flags()) || method.declaringClass().isInterface() || !method.returnType().name().equals((Object)DotNames.UNI) || !entityReposUsers.contains(method.declaringClass().name()) || !Annotations.containsAny((Collection)annotations, (Iterable)designators) || Annotations.containsAny((Collection)annotations, (Iterable)bindings)) {
                        return;
                    }
                    context.transform().add(DotNames.WITH_SESSION_ON_DEMAND, new AnnotationValue[0]).done();
                }
            }));
        }
    }

    @BuildStep
    void lookupNamedQueries(CombinedIndexBuildItem index, BuildProducer<PanacheNamedQueryEntityClassBuildStep> namedQueries, JpaModelBuildItem jpaModel) {
        for (String modelClass : jpaModel.getAllModelClassNames()) {
            HashMap<String, String> typeNamedQueries = new HashMap<String, String>();
            this.lookupNamedQueries(index, DotName.createSimple((String)modelClass), typeNamedQueries);
            namedQueries.produce((BuildItem)new PanacheNamedQueryEntityClassBuildStep(modelClass, typeNamedQueries));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildNamedQueryMap(List<PanacheNamedQueryEntityClassBuildStep> namedQueryEntityClasses, PanacheHibernateRecorder panacheHibernateRecorder) {
        HashMap<String, Map<String, String>> namedQueryMap = new HashMap<String, Map<String, String>>();
        for (PanacheNamedQueryEntityClassBuildStep entityNamedQueries : namedQueryEntityClasses) {
            namedQueryMap.put(entityNamedQueries.getClassName(), entityNamedQueries.getNamedQueries());
        }
        panacheHibernateRecorder.setNamedQueryMap(namedQueryMap);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void shutdown(ShutdownContextBuildItem shutdownContextBuildItem, PanacheHibernateRecorder panacheHibernateRecorder) {
        panacheHibernateRecorder.clear((ShutdownContext)shutdownContextBuildItem);
    }

    private void lookupNamedQueries(CombinedIndexBuildItem index, DotName name, Map<String, String> namedQueries) {
        List namedQueriesInstances;
        ClassInfo classInfo = index.getComputingIndex().getClassByName(name);
        if (classInfo == null) {
            return;
        }
        List namedQueryInstances = (List)classInfo.annotationsMap().get(DotNames.DOTNAME_NAMED_QUERY);
        if (namedQueryInstances != null) {
            for (Object namedQueryInstance : namedQueryInstances) {
                namedQueries.put(namedQueryInstance.value("name").asString(), namedQueryInstance.value("query").asString());
            }
        }
        if ((namedQueriesInstances = (List)classInfo.annotationsMap().get(DotNames.DOTNAME_NAMED_QUERIES)) != null) {
            for (AnnotationInstance namedQueriesInstance : namedQueriesInstances) {
                AnnotationInstance[] nestedInstances;
                AnnotationValue value = namedQueriesInstance.value();
                for (AnnotationInstance nested : nestedInstances = value.asNestedArray()) {
                    namedQueries.put(nested.value("name").asString(), nested.value("query").asString());
                }
            }
        }
        if (!classInfo.superClassType().name().equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            Type superType = classInfo.superClassType();
            ClassInfo superClass = index.getComputingIndex().getClassByName(superType.name());
            if (superClass != null) {
                this.lookupNamedQueries(index, superClass.name(), namedQueries);
            }
        }
    }

    private void validateBindings(List<DotName> bindings, Map.Entry<MethodInfo, Set<AnnotationInstance>> entry, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        for (DotName binding : bindings) {
            for (AnnotationInstance annotation : entry.getValue()) {
                if (!annotation.name().equals((Object)binding)) continue;
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                    errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A method annotated with @" + binding.withoutPackagePrefix() + " must return io.smallrye.mutiny.Uni: " + String.valueOf(entry.getKey()) + " declared on " + String.valueOf(entry.getKey().declaringClass()))}));
                } else {
                    LOG.debugf("Class-level binding %s will be ignored for method %s() declared on %s", (Object)binding, (Object)entry.getKey().name(), (Object)entry.getKey().declaringClass());
                }
                return;
            }
        }
    }
}

