/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.reactive.deployment.ClassNames;
import io.quarkus.hibernate.reactive.runtime.HibernateReactiveRecorder;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.util.Arrays;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class HibernateReactiveCdiProcessor {
    private static final List<DotName> MUTINY_SESSION_FACTORY_EXPOSED_TYPES = Arrays.asList(ClassNames.MUTINY_SESSION_FACTORY, ClassNames.IMPLEMENTOR);

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void produceSessionFactoryBean(HibernateReactiveRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (persistenceUnitDescriptors.isEmpty()) {
            return;
        }
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            String persistenceUnitName = persistenceUnitDescriptor.getPersistenceUnitName();
            boolean isDefaultPU = PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName);
            boolean isReactive = persistenceUnitDescriptor.isReactive();
            if (!isReactive) continue;
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Mutiny.SessionFactory.class).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit().startup()).checkActive(recorder.checkActiveSupplier(persistenceUnitName, persistenceUnitDescriptor.getConfig().getDataSource(), persistenceUnitDescriptor.getConfig().getEntityClassNames())).createWith(recorder.mutinySessionFactory(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(JPAConfig.class)), new AnnotationInstance[0]);
            for (DotName exposedType : MUTINY_SESSION_FACTORY_EXPOSED_TYPES) {
                configurator.addType(exposedType);
            }
            configurator.defaultBean();
            if (isDefaultPU) {
                configurator.addQualifier(Default.class);
            } else {
                configurator.addQualifier().annotation(io.quarkus.hibernate.orm.deployment.ClassNames.QUARKUS_PERSISTENCE_UNIT).addValue("value", (Object)persistenceUnitName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
    }
}

