/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.RecorderBeanInitializedBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.HibernateOrmProcessor;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.hibernate.orm.deployment.util.HibernateProcessorUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.customized.BuiltinFormatMapperBehaviour;
import io.quarkus.hibernate.orm.runtime.customized.FormatMapperKind;
import io.quarkus.hibernate.orm.runtime.customized.JsonFormatterCustomizationCheck;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.reactive.deployment.HibernateReactiveEnabled;
import io.quarkus.hibernate.reactive.runtime.FastBootHibernateReactivePersistenceProvider;
import io.quarkus.hibernate.reactive.runtime.HibernateReactiveRecorder;
import io.quarkus.reactive.datasource.deployment.ReactiveDataSourceBuildItem;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.persistence.PersistenceUnitTransactionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import org.hibernate.reactive.provider.impl.ReactiveIntegrator;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateReactiveEnabled.class})
public final class HibernateReactiveProcessor {
    private static final String HIBERNATE_REACTIVE = "Hibernate Reactive";
    private static final Logger LOG = Logger.getLogger(HibernateReactiveProcessor.class);
    static final String[] REFLECTIVE_CONSTRUCTORS_NEEDED = new String[]{"org.hibernate.reactive.persister.entity.impl.ReactiveSingleTableEntityPersister", "org.hibernate.reactive.persister.entity.impl.ReactiveJoinedSubclassEntityPersister", "org.hibernate.reactive.persister.entity.impl.ReactiveUnionSubclassEntityPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveOneToManyPersister", "org.hibernate.reactive.persister.collection.impl.ReactiveBasicCollectionPersister"};

    @BuildStep
    void registerServicesForReflection(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)new ServiceProviderBuildItem("io.vertx.core.spi.VertxServiceProvider", new String[]{"org.hibernate.reactive.context.impl.ContextualDataStorage"}));
    }

    @BuildStep
    void reflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, REFLECTIVE_CONSTRUCTORS_NEEDED));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateReactiveRecorder recorder, JpaModelBuildItem jpaModel) {
        boolean enableRx = HibernateProcessorUtil.hasEntities((JpaModelBuildItem)jpaModel);
        recorder.callHibernateReactiveFeatureInit(enableRx);
    }

    @BuildStep
    public void buildReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, List<ReactiveDataSourceBuildItem> reactiveDataSources, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaModelBuildItem jpaModel, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        boolean enableDefaultPersistenceUnit;
        boolean enableHR = HibernateProcessorUtil.hasEntities((JpaModelBuildItem)jpaModel);
        if (!enableHR) {
            LOG.warn((Object)"Hibernate Reactive is disabled because no JPA entities were found");
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            String provider = persistenceXmlDescriptorBuildItem.getDescriptor().getProviderClassName();
            if (provider != null && !provider.equals(FastBootHibernateReactivePersistenceProvider.class.getCanonicalName()) && !provider.equals("org.hibernate.reactive.provider.ReactivePersistenceProvider")) continue;
            throw new ConfigurationException("Cannot use persistence.xml with Hibernate Reactive in Quarkus. Must use application.properties instead.");
        }
        Optional<ReactiveDataSourceBuildItem> defaultReactiveDataSource = reactiveDataSources.stream().filter(i -> i.isDefault()).findFirst();
        boolean bl = enableDefaultPersistenceUnit = defaultReactiveDataSource.isPresent() && hibernateOrmConfig.namedPersistenceUnits().isEmpty() || hibernateOrmConfig.defaultPersistenceUnit().isAnyPropertySet();
        if (enableDefaultPersistenceUnit) {
            HibernateReactiveProcessor.producePersistenceUnitFromConfig(hibernateOrmConfig, "<default>", hibernateOrmConfig.defaultPersistenceUnit(), index, enableDefaultPersistenceUnit, reactiveDataSources, jdbcDataSources, applicationArchivesBuildItem, jpaModel, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, unremovableBeans, dbKindDialectBuildItems);
        }
        for (Map.Entry persistenceUnitEntry : hibernateOrmConfig.namedPersistenceUnits().entrySet()) {
            String namedPersistenceUnitName = (String)persistenceUnitEntry.getKey();
            HibernateOrmConfigPersistenceUnit persistenceUnitConfig = (HibernateOrmConfigPersistenceUnit)hibernateOrmConfig.namedPersistenceUnits().get(namedPersistenceUnitName);
            HibernateReactiveProcessor.producePersistenceUnitFromConfig(hibernateOrmConfig, namedPersistenceUnitName, persistenceUnitConfig, index, enableDefaultPersistenceUnit, reactiveDataSources, jdbcDataSources, applicationArchivesBuildItem, jpaModel, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, unremovableBeans, dbKindDialectBuildItems);
        }
    }

    private static void producePersistenceUnitFromConfig(HibernateOrmConfig hibernateOrmConfig, String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, CombinedIndexBuildItem index, boolean enableDefaultPersistenceUnit, List<ReactiveDataSourceBuildItem> reactiveDataSources, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, JpaModelBuildItem jpaModel, LaunchModeBuildItem launchMode, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        boolean datasourceNamed = persistenceUnitConfig.datasource().isPresent();
        Optional<JdbcDataSourceBuildItem> jdbcDataSource = HibernateReactiveProcessor.findDataSourceWithNameDefault(persistenceUnitName, persistenceUnitConfig, jdbcDataSources, JdbcDataSourceBuildItem::getName, JdbcDataSourceBuildItem::isDefault);
        Optional<ReactiveDataSourceBuildItem> reactiveDataSource = HibernateReactiveProcessor.findDataSourceWithNameDefault(persistenceUnitName, persistenceUnitConfig, reactiveDataSources, ReactiveDataSourceBuildItem::getName, ReactiveDataSourceBuildItem::isDefault);
        if (jdbcDataSource.isPresent() && reactiveDataSource.isEmpty() && datasourceNamed) {
            LOG.debugf("The datasource '%s' is blocking, do not create this PU '%s' as reactive", persistenceUnitConfig.datasource().get(), (Object)persistenceUnitName);
            return;
        }
        if (jdbcDataSource.isEmpty() && reactiveDataSource.isEmpty() && datasourceNamed) {
            String dataSourceName = (String)persistenceUnitConfig.datasource().get();
            throw PersistenceUnitUtil.unableToFindDataSource((String)persistenceUnitName, (String)dataSourceName, (Throwable)DataSourceUtil.dataSourceNotConfigured((String)dataSourceName));
        }
        Optional<String> datasourceName = reactiveDataSource.map(ReactiveDataSourceBuildItem::getName);
        Optional explicitDialect = persistenceUnitConfig.dialect().dialect();
        Optional<String> explicitDbMinVersion = reactiveDataSource.flatMap(ReactiveDataSourceBuildItem::getVersion);
        Optional<String> dbKindOptional = reactiveDataSource.map(ReactiveDataSourceBuildItem::getDbKind);
        Optional dbVersion = reactiveDataSource.flatMap(ReactiveDataSourceBuildItem::getVersion);
        if (dbKindOptional.isEmpty()) {
            throw new ConfigurationException("The datasource must be configured for Hibernate Reactive. Refer to https://quarkus.io/guides/datasource for guidance.", Set.of("quarkus.datasource.db-kind", "quarkus.datasource.username", "quarkus.datasource.password"));
        }
        QuarkusPersistenceUnitDescriptorWithSupportedDBKind reactivePUWithDBKind = HibernateReactiveProcessor.generateReactivePersistenceUnit(hibernateOrmConfig, persistenceUnitName, index, persistenceUnitConfig, jpaModel, dbKindOptional, explicitDialect, explicitDbMinVersion, applicationArchivesBuildItem, launchMode.getLaunchMode(), systemProperties, nativeImageResources, hotDeploymentWatchedFiles, dbKindDialectBuildItems, enableDefaultPersistenceUnit);
        Optional jsonMapper = HibernateProcessorUtil.jsonMapperKind((Capabilities)capabilities, (BuiltinFormatMapperBehaviour)hibernateOrmConfig.mapping().format().global());
        Optional xmlMapper = HibernateProcessorUtil.xmlMapperKind((Capabilities)capabilities, (BuiltinFormatMapperBehaviour)hibernateOrmConfig.mapping().format().global());
        jsonMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
        xmlMapper.flatMap(FormatMapperKind::requiredBeanType).ifPresent(type -> unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{type})));
        JsonFormatterCustomizationCheck jsonFormatterCustomizationCheck = HibernateProcessorUtil.jsonFormatterCustomizationCheck((Capabilities)capabilities, (Optional)jsonMapper);
        QuarkusPersistenceUnitDescriptor reactivePU = reactivePUWithDBKind.descriptor();
        persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(reactivePU, new RecordedConfig(datasourceName, dbKindOptional, reactivePUWithDBKind.supportedDatabaseKind.map(DatabaseKind.SupportedDatabaseKind::getMainName), dbVersion, persistenceUnitConfig.dialect().dialect(), MultiTenancyStrategy.NONE, hibernateOrmConfig.database().ormCompatibilityVersion(), hibernateOrmConfig.mapping().format().global(), jsonFormatterCustomizationCheck, persistenceUnitConfig.unsupportedProperties()), null, jpaModel.getXmlMappings(reactivePU.getName()), false, HibernateProcessorUtil.isHibernateValidatorPresent((Capabilities)capabilities), jsonMapper, xmlMapper));
    }

    private static <T> Optional<T> findDataSourceWithNameDefault(String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, List<T> datasSources, Function<T, String> nameExtractor, Function<T, Boolean> defaultExtractor) {
        if (persistenceUnitConfig.datasource().isPresent()) {
            String dataSourceName = (String)persistenceUnitConfig.datasource().get();
            return datasSources.stream().filter(i -> dataSourceName.equals(nameExtractor.apply(i))).findFirst();
        }
        if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            return datasSources.stream().filter(i -> (Boolean)defaultExtractor.apply(i)).findFirst();
        }
        return Optional.empty();
    }

    @BuildStep
    @Consume(value=VertxPoolBuildItem.class)
    void waitForVertxPool(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_REACTIVE, puDescriptor.getPersistenceUnitName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    PersistenceProviderSetUpBuildItem setUpPersistenceProviderAndWaitForVertxPool(HibernateReactiveRecorder recorder, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems, BuildProducer<RecorderBeanInitializedBuildItem> orderEnforcer) {
        recorder.initializePersistenceProvider(HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        return new PersistenceProviderSetUpBuildItem();
    }

    @BuildStep
    void silenceLogging(BuildProducer<LogCategoryBuildItem> logCategories) {
        logCategories.produce((BuildItem)new LogCategoryBuildItem(ReactiveIntegrator.class.getName(), Level.WARNING));
    }

    private static QuarkusPersistenceUnitDescriptorWithSupportedDBKind generateReactivePersistenceUnit(HibernateOrmConfig hibernateOrmConfig, String persistenceUnitName, CombinedIndexBuildItem index, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, JpaModelBuildItem jpaModel, Optional<String> dbKindOptional, Optional<String> explicitDialect, Optional<String> explicitDbMinVersion, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems, boolean enableDefaultPersistenceUnit) {
        Map modelClassesAndPackagesPerPersistencesUnits = HibernateOrmProcessor.getModelClassesAndPackagesPerPersistenceUnits((HibernateOrmConfig)hibernateOrmConfig, (JpaModelBuildItem)jpaModel, (IndexView)index.getIndex(), (boolean)enableDefaultPersistenceUnit);
        Set modelClassesAndPackages = modelClassesAndPackagesPerPersistencesUnits.getOrDefault(persistenceUnitName, Collections.emptySet());
        if (modelClassesAndPackages.isEmpty()) {
            LOG.warnf("Could not find any entities affected to the Hibernate Reactive persistence unit.", new Object[0]);
        }
        QuarkusPersistenceUnitDescriptor descriptor = new QuarkusPersistenceUnitDescriptor(persistenceUnitName, PersistenceUnitTransactionType.RESOURCE_LOCAL, new ArrayList(modelClassesAndPackages), new Properties(), true);
        HashSet storageEngineCollector = new HashSet();
        HibernateOrmConfigPersistenceUnit.HibernateOrmConfigPersistenceUnitDialect dialectConfig = persistenceUnitConfig.dialect();
        Optional supportedDatabaseKind = HibernateProcessorUtil.setDialectAndStorageEngine((String)persistenceUnitName, dbKindOptional, explicitDialect, explicitDbMinVersion, (HibernateOrmConfigPersistenceUnit.HibernateOrmConfigPersistenceUnitDialect)dialectConfig, dbKindDialectBuildItems, systemProperties, descriptor.getProperties()::setProperty, storageEngineCollector);
        HibernateProcessorUtil.configureProperties((QuarkusPersistenceUnitDescriptor)descriptor, (HibernateOrmConfigPersistenceUnit)persistenceUnitConfig, (HibernateOrmConfig)hibernateOrmConfig, (boolean)true);
        HibernateProcessorUtil.configureSqlLoadScript((String)persistenceUnitName, (HibernateOrmConfigPersistenceUnit)persistenceUnitConfig, (ApplicationArchivesBuildItem)applicationArchivesBuildItem, (LaunchMode)launchMode, nativeImageResources, hotDeploymentWatchedFiles, (QuarkusPersistenceUnitDescriptor)descriptor);
        return new QuarkusPersistenceUnitDescriptorWithSupportedDBKind(descriptor, supportedDatabaseKind);
    }

    record QuarkusPersistenceUnitDescriptorWithSupportedDBKind(QuarkusPersistenceUnitDescriptor descriptor, Optional<DatabaseKind.SupportedDatabaseKind> supportedDatabaseKind) {
    }
}

