/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.envers;

import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfig;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;

@Recorder
public class HibernateEnversRecorder {
    public HibernateOrmIntegrationStaticInitListener createStaticInitListener(HibernateEnversBuildTimeConfig buildTimeConfig, String puName) {
        return new HibernateEnversIntegrationStaticInitListener(buildTimeConfig, puName);
    }

    public HibernateOrmIntegrationStaticInitListener createStaticInitInactiveListener() {
        return new HibernateEnversIntegrationStaticInitInactiveListener();
    }

    private static final class HibernateEnversIntegrationStaticInitListener
    implements HibernateOrmIntegrationStaticInitListener {
        private final HibernateEnversBuildTimeConfig buildTimeConfig;
        private final String puName;

        private HibernateEnversIntegrationStaticInitListener(HibernateEnversBuildTimeConfig buildTimeConfig, String puName) {
            this.buildTimeConfig = buildTimeConfig;
            this.puName = puName;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateEnversBuildTimeConfigPersistenceUnit puConfig = this.buildTimeConfig.persistenceUnits().get(this.puName);
            if (puConfig == null) {
                return;
            }
            if (puConfig.active().isPresent() && !puConfig.active().get().booleanValue()) {
                propertyCollector.accept("hibernate.integration.envers.enabled", "false");
                return;
            }
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.store_data_at_delete", puConfig.storeDataAtDelete());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.audit_table_suffix", puConfig.auditTableSuffix());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.audit_table_prefix", puConfig.auditTablePrefix());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.revision_field_name", puConfig.revisionFieldName());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.revision_type_field_name", puConfig.revisionTypeFieldName());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.revision_on_collection_change", puConfig.revisionOnCollectionChange());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.do_not_audit_optimistic_locking_field", puConfig.doNotAuditOptimisticLockingField());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.default_schema", puConfig.defaultSchema());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.default_catalog", puConfig.defaultCatalog());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.track_entities_changed_in_revision", puConfig.trackEntitiesChangedInRevision());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.use_revision_entity_with_native_id", puConfig.useRevisionEntityWithNativeId());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.global_with_modified_flag", puConfig.globalWithModifiedFlag());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.modified_flag_suffix", puConfig.modifiedFlagSuffix());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.revision_listener", puConfig.revisionListener());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.audit_strategy", puConfig.auditStrategy());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.original_id_prop_name", puConfig.originalIdPropName());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.audit_strategy_validity_end_rev_field_name", puConfig.auditStrategyValidityEndRevFieldName());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", puConfig.auditStrategyValidityStoreRevendTimestamp());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", puConfig.auditStrategyValidityRevendTimestampFieldName());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.embeddable_set_ordinal_field_name", puConfig.embeddableSetOrdinalFieldName());
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.allow_identifier_reuse", puConfig.allowIdentifierReuse());
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.modified_column_naming_strategy", puConfig.modifiedColumnNamingStrategy());
        }

        public static <T> void addConfig(BiConsumer<String, Object> propertyCollector, String configPath, T value) {
            propertyCollector.accept(configPath, value);
        }

        public static <T> void addConfig(BiConsumer<String, Object> propertyCollector, String configPath, Optional<T> value) {
            if (value.isPresent()) {
                propertyCollector.accept(configPath, value.get());
            } else {
                propertyCollector.accept(configPath, "");
            }
        }

        public static <T> void addConfigIfPresent(BiConsumer<String, Object> propertyCollector, String configPath, Optional<T> value) {
            value.ifPresent(t -> propertyCollector.accept(configPath, t));
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }

    private static final class HibernateEnversIntegrationStaticInitInactiveListener
    implements HibernateOrmIntegrationStaticInitListener {
        private HibernateEnversIntegrationStaticInitInactiveListener() {
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.integration.envers.enabled", "false");
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }
}

