/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.envers.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfig;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.envers.HibernateEnversRecorder;
import io.quarkus.hibernate.envers.deployment.HibernateEnversEnabled;
import io.quarkus.hibernate.envers.runtime.graal.DisableLoggingFeature;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@BuildSteps(onlyIf={HibernateEnversEnabled.class})
public final class HibernateEnversProcessor {
    static final String HIBERNATE_ENVERS = "Hibernate Envers";

    @BuildStep
    List<AdditionalJpaModelBuildItem> addJpaModelClasses() {
        return Arrays.asList(new AdditionalJpaModelBuildItem("org.hibernate.envers.DefaultRevisionEntity"), new AdditionalJpaModelBuildItem("org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity"));
    }

    @BuildStep
    public void registerEnversReflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, HibernateEnversBuildTimeConfig buildTimeConfig) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.hibernate.envers.DefaultRevisionEntity", "org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity"}).reason(this.getClass().getName()).methods().build());
        ArrayList classes = new ArrayList(buildTimeConfig.persistenceUnits().size() * 2);
        for (HibernateEnversBuildTimeConfigPersistenceUnit pu : buildTimeConfig.persistenceUnits().values()) {
            pu.revisionListener().ifPresent(classes::add);
            pu.auditStrategy().ifPresent(classes::add);
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).reason("Configured Envers listeners and audit strategies").methods().fields().build());
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(DisableLoggingFeature.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void applyStaticConfig(HibernateEnversRecorder recorder, HibernateEnversBuildTimeConfig buildTimeConfig, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationProducer) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            String puName = puDescriptor.getPersistenceUnitName();
            integrationProducer.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_ENVERS, puName).setInitListener(recorder.createStaticInitListener(buildTimeConfig, puName)).setXmlMappingRequired(true));
        }
    }
}

