/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gcp.functions.http;

import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.netty.runtime.virtual.VirtualResponseHandler;
import io.quarkus.runtime.Application;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jboss.logging.Logger;

public class QuarkusHttpFunction
implements HttpFunction {
    private static final Logger LOG = Logger.getLogger(QuarkusHttpFunction.class);
    protected static final String deploymentStatus;
    protected static boolean started;
    private static final int BUFFER_SIZE = 8096;

    public void service(HttpRequest request, com.google.cloud.functions.HttpResponse response) throws IOException {
        if (!started) {
            throw new IOException(deploymentStatus);
        }
        this.dispatch(request, response);
    }

    private void dispatch(HttpRequest request, com.google.cloud.functions.HttpResponse response) throws IOException {
        try {
            this.nettyDispatch(request, response);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nettyDispatch(HttpRequest request, com.google.cloud.functions.HttpResponse response) throws InterruptedException, IOException, ExecutionException {
        String path = request.getPath();
        Optional host = request.getFirstHeader("Host");
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getMethod()), request.getQuery().map(q -> path + "?" + q).orElse(path));
        if (host.isPresent()) {
            nettyRequest.headers().set("Host", host.get());
        }
        for (Map.Entry header : request.getHeaders().entrySet()) {
            nettyRequest.headers().add((String)header.getKey(), (Iterable)header.getValue());
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (request.getContentLength() != 0L) {
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[8096];
                while ((nRead = request.getInputStream().read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] byteArray = buffer.toByteArray();
                ByteBuf body = Unpooled.wrappedBuffer((byte[])byteArray);
                requestContent = new DefaultLastHttpContent(body);
            }
        }
        ResponseHandler handler = new ResponseHandler(response);
        VirtualClientConnection connection = VirtualClientConnection.connect((VirtualResponseHandler)handler, (VirtualAddress)VertxHttpRecorder.VIRTUAL_HTTP);
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
        try {
            handler.future.get();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        started = false;
        StringWriter error = new StringWriter();
        PrintWriter errorWriter = new PrintWriter((Writer)error, true);
        if (Application.currentApplication() == null) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(QuarkusHttpFunction.class.getClassLoader());
                Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl");
                String[] args = new String[]{};
                Application app = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                app.start(args);
                errorWriter.println("Quarkus bootstrapped successfully.");
                started = true;
            }
            catch (Exception ex) {
                errorWriter.println("Quarkus bootstrap failed.");
                ex.printStackTrace(errorWriter);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCl);
            }
        } else {
            errorWriter.println("Quarkus bootstrapped successfully.");
            started = true;
        }
        deploymentStatus = error.toString();
    }

    private static class ResponseHandler
    implements VirtualResponseHandler {
        ByteArrayOutputStream baos;
        WritableByteChannel byteChannel;
        CompletableFuture<Void> future = new CompletableFuture();
        final com.google.cloud.functions.HttpResponse response;

        public ResponseHandler(com.google.cloud.functions.HttpResponse response) {
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Object msg) {
            block15: {
                try {
                    FileRegion file;
                    if (msg instanceof HttpResponse) {
                        HttpResponse res = (HttpResponse)msg;
                        this.response.setStatusCode(res.status().code(), res.status().reasonPhrase());
                        for (Map.Entry entry : res.headers()) {
                            this.response.appendHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    if (msg instanceof HttpContent) {
                        HttpContent content = (HttpContent)msg;
                        if (this.baos == null) {
                            this.baos = new ByteArrayOutputStream(8096);
                        }
                        int readable = content.content().readableBytes();
                        for (int i = 0; i < readable; ++i) {
                            this.baos.write(content.content().readByte());
                        }
                    }
                    if (msg instanceof FileRegion && (file = (FileRegion)msg).count() > 0L && file.transferred() < file.count()) {
                        if (this.baos == null) {
                            this.baos = new ByteArrayOutputStream(8096);
                        }
                        if (this.byteChannel == null) {
                            this.byteChannel = Channels.newChannel(this.baos);
                        }
                        file.transferTo(this.byteChannel, file.transferred());
                    }
                    if (!(msg instanceof LastHttpContent)) break block15;
                    this.baos.writeTo(this.response.getOutputStream());
                    try {
                        this.baos.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Unable to close the ByteArrayOutputStream", (Throwable)e);
                    }
                    this.future.complete(null);
                }
                catch (Throwable ex) {
                    this.future.completeExceptionally(ex);
                }
                finally {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        public void close() {
            if (!this.future.isDone()) {
                this.future.completeExceptionally(new RuntimeException("Connection closed"));
            }
        }
    }
}

