/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.gcp.functions;

import com.google.cloud.functions.CloudEventsFunction;
import io.cloudevents.CloudEvent;
import io.quarkus.funqy.gcp.functions.FunqyCloudFunctionsBindingRecorder;
import io.quarkus.runtime.Application;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class FunqyCloudEventsFunction
implements CloudEventsFunction {
    protected static final String deploymentStatus;
    protected static boolean started;

    public void accept(CloudEvent cloudEvent) throws Exception {
        if (!started) {
            throw new RuntimeException(deploymentStatus);
        }
        FunqyCloudFunctionsBindingRecorder.handle(cloudEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        started = false;
        StringWriter error = new StringWriter();
        PrintWriter errorWriter = new PrintWriter((Writer)error, true);
        if (Application.currentApplication() == null) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(FunqyCloudEventsFunction.class.getClassLoader());
                Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl");
                String[] args = new String[]{};
                final Application app = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        app.stop();
                    }
                });
                app.start(args);
                errorWriter.println("Quarkus bootstrapped successfully.");
                started = true;
            }
            catch (Exception ex) {
                errorWriter.println("Quarkus bootstrap failed.");
                ex.printStackTrace(errorWriter);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCl);
            }
        } else {
            errorWriter.println("Quarkus bootstrapped successfully.");
            started = true;
        }
        deploymentStatus = error.toString();
    }
}

