/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event.sns;

import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.lambda.event.EventHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class SnsEventHandler
implements EventHandler<SNSEvent, SNSEvent.SNSRecord, Void> {
    @Override
    public Stream<SNSEvent.SNSRecord> streamEvent(SNSEvent event, FunqyAmazonConfig amazonConfig) {
        if (event == null) {
            return Stream.empty();
        }
        return event.getRecords().stream();
    }

    @Override
    public String getIdentifier(SNSEvent.SNSRecord message, FunqyAmazonConfig amazonConfig) {
        return message.getSNS().getMessageId();
    }

    @Override
    public Supplier<InputStream> getBody(SNSEvent.SNSRecord message, FunqyAmazonConfig amazonConfig) {
        if (message.getSNS() == null) {
            return InputStream::nullInputStream;
        }
        return () -> new ByteArrayInputStream(message.getSNS().getMessage().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Void createResponse(List<String> failures, FunqyAmazonConfig amazonConfig) {
        return null;
    }

    @Override
    public Class<SNSEvent.SNSRecord> getMessageClass() {
        return SNSEvent.SNSRecord.class;
    }
}

