/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.funqy.lambda.FunqyResponseImpl;
import io.quarkus.funqy.lambda.config.FunqyAmazonBuildTimeConfig;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.lambda.event.EventErrorHandler;
import io.quarkus.funqy.lambda.event.EventHandler;
import io.quarkus.funqy.lambda.event.cloudevents.CloudEventsHandler;
import io.quarkus.funqy.lambda.event.dynamodb.DynamoDbEventHandler;
import io.quarkus.funqy.lambda.event.dynamodb.PipesDynamoDbEventHandler;
import io.quarkus.funqy.lambda.event.kinesis.KinesisEventHandler;
import io.quarkus.funqy.lambda.event.kinesis.PipesKinesisEventHandler;
import io.quarkus.funqy.lambda.event.sns.SnsEventHandler;
import io.quarkus.funqy.lambda.event.sqs.PipesSqsEventHandler;
import io.quarkus.funqy.lambda.event.sqs.SqsEventHandler;
import io.quarkus.funqy.lambda.model.cloudevents.CloudEventV1;
import io.quarkus.funqy.lambda.model.kinesis.PipesKinesisEvent;
import io.quarkus.funqy.runtime.FunqyServerResponse;
import io.smallrye.mutiny.Uni;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class EventProcessor {
    private static final Logger log = Logger.getLogger(EventProcessor.class);
    private final ObjectReader objectReader;
    private final FunqyAmazonConfig config;
    private final Map<Class<?>, EventHandler<?, ?, ?>> eventHandlers;

    public EventProcessor(ObjectReader objectReader, FunqyAmazonBuildTimeConfig buildTimeConfig, FunqyAmazonConfig config) {
        this.objectReader = objectReader;
        this.config = config;
        this.eventHandlers = new HashMap();
        if (buildTimeConfig.advancedEventHandling().enabled()) {
            this.eventHandlers.put(SQSEvent.class, new SqsEventHandler());
            this.eventHandlers.put(SQSEvent.SQSMessage.class, new PipesSqsEventHandler());
            this.eventHandlers.put(SNSEvent.class, new SnsEventHandler());
            this.eventHandlers.put(KinesisEvent.class, new KinesisEventHandler());
            this.eventHandlers.put(PipesKinesisEvent.class, new PipesKinesisEventHandler());
            this.eventHandlers.put(DynamodbEvent.class, new DynamoDbEventHandler());
            this.eventHandlers.put(DynamodbEvent.DynamodbStreamRecord.class, new PipesDynamoDbEventHandler());
            this.eventHandlers.put(CloudEventV1.class, new CloudEventsHandler());
        }
    }

    public FunqyServerResponse handle(Object event, Function<Object, FunqyServerResponse> dispatcher, Context context) throws IOException {
        EventHandler<?, ?, ?> handler = this.getHandler(event);
        if (handler != null) {
            EventErrorHandler eventErrorHandler = new EventErrorHandler();
            FunqyResponseImpl funqyResponse = new FunqyResponseImpl();
            funqyResponse.setOutput(this.handleEvent(handler, event, eventErrorHandler, dispatcher));
            return funqyResponse;
        }
        return dispatcher.apply(event);
    }

    private EventHandler<?, ?, ?> getHandler(Object event) {
        List list;
        if (event == null) {
            return null;
        }
        if (event instanceof List && !(list = (List)event).isEmpty()) {
            return this.eventHandlers.get(list.get(0).getClass());
        }
        return this.eventHandlers.get(event.getClass());
    }

    private <E, M, R> Uni<?> handleEvent(EventHandler<E, M, R> handler, Object event, EventErrorHandler eventErrorHandler, Function<Object, FunqyServerResponse> dispatcher) {
        List<Uni> unis = handler.streamEvent(event, this.config).map(msg -> this.handleMessage(handler, eventErrorHandler, dispatcher, msg)).toList();
        log.debugv("Received {0} messages in a batch.", (Object)unis.size());
        return Uni.combine().all().unis(unis).collectFailures().discardItems().onFailure().invoke(err -> log.errorv(err, "An exception occurred during message handling.", new Object[0])).onFailure().recoverWithNull().replaceWith(() -> {
            log.debugv("Detected {0} errors during message handling.", (Object)unis.size());
            return handler.createResponse(eventErrorHandler.getFailures(), this.config);
        });
    }

    private <E, M, R> Uni<?> handleMessage(EventHandler<E, M, R> handler, EventErrorHandler eventErrorHandler, Function<Object, FunqyServerResponse> dispatcher, M msg) {
        try {
            Object input;
            boolean isUsingEventModel = Optional.ofNullable(this.objectReader).map(ObjectReader::getValueType).map(type -> type.hasRawClass(handler.getMessageClass())).orElse(false);
            if (isUsingEventModel) {
                log.debug((Object)"Funqy method is using the event model. No further deserialization necessary.");
                input = msg;
            } else {
                log.debug((Object)"Funqy method is using a custom model. Try to deserialize message.");
                input = this.readMessageBody(handler.getBody(msg, this.config));
            }
            FunqyServerResponse response = dispatcher.apply(input);
            return eventErrorHandler.collectFailures(response.getOutput(), handler.getIdentifier(msg, this.config));
        }
        catch (Throwable e) {
            log.errorv(e, "Event could not be handled. This can have multiple reasons:\n1. Message body could not be deserialized\n2. Using a not supported AWS event\n", new Object[0]);
            return eventErrorHandler.collectFailures(Uni.createFrom().failure(e), handler.getIdentifier(msg, this.config));
        }
    }

    private Object readMessageBody(Supplier<InputStream> is) throws IOException {
        if (this.objectReader == null) {
            return null;
        }
        return this.objectReader.readValue(is.get());
    }
}

