/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event.dynamodb;

import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.StreamsEventResponse;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.lambda.event.EventHandler;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class PipesDynamoDbEventHandler
implements EventHandler<List<DynamodbEvent.DynamodbStreamRecord>, DynamodbEvent.DynamodbStreamRecord, StreamsEventResponse> {
    @Override
    public Stream<DynamodbEvent.DynamodbStreamRecord> streamEvent(List<DynamodbEvent.DynamodbStreamRecord> event, FunqyAmazonConfig amazonConfig) {
        if (event == null) {
            return Stream.empty();
        }
        return event.stream();
    }

    @Override
    public String getIdentifier(DynamodbEvent.DynamodbStreamRecord message, FunqyAmazonConfig amazonConfig) {
        return message.getDynamodb().getSequenceNumber();
    }

    @Override
    public Supplier<InputStream> getBody(DynamodbEvent.DynamodbStreamRecord message, FunqyAmazonConfig amazonConfig) {
        throw new IllegalStateException("DynamoDB records are too specific. It is not supported to extract a message from them. Use the DynamodbStreamRecord in your funq method, or use EventBridge Pipes with CloudEvents.\n");
    }

    @Override
    public StreamsEventResponse createResponse(List<String> failures, FunqyAmazonConfig amazonConfig) {
        if (!amazonConfig.advancedEventHandling().dynamoDb().reportBatchItemFailures()) {
            return null;
        }
        return StreamsEventResponse.builder().withBatchItemFailures(failures.stream().map(id -> StreamsEventResponse.BatchItemFailure.builder().withItemIdentifier(id).build()).toList()).build();
    }

    @Override
    public Class<DynamodbEvent.DynamodbStreamRecord> getMessageClass() {
        return DynamodbEvent.DynamodbStreamRecord.class;
    }
}

