/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event;

import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.cloudevents.SpecVersion;
import io.quarkus.amazon.lambda.runtime.LambdaInputReader;
import io.quarkus.funqy.lambda.config.FunqyAmazonBuildTimeConfig;
import io.quarkus.funqy.lambda.event.DateDeserializer;
import io.quarkus.funqy.lambda.model.cloudevents.CloudEventV1;
import io.quarkus.funqy.lambda.model.kinesis.PipesKinesisEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;

public class AwsEventInputReader
implements LambdaInputReader<Object> {
    private static final Logger log = Logger.getLogger(AwsEventInputReader.class);
    private static final String SQS_EVENT_SOURCE = "aws:sqs";
    private static final String SNS_EVENT_SOURCE = "aws:sns";
    private static final String KINESIS_EVENT_SOURCE = "aws:kinesis";
    private static final String DYNAMODB_EVENT_SOURCE = "aws:dynamodb";
    final ObjectMapper mapper;
    final FunqyAmazonBuildTimeConfig amazonBuildTimeConfig;
    final ObjectReader reader;

    public AwsEventInputReader(ObjectMapper mapper, ObjectReader reader, FunqyAmazonBuildTimeConfig amazonBuildTimeConfig) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        mapper.registerModule((Module)simpleModule);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper = mapper;
        this.amazonBuildTimeConfig = amazonBuildTimeConfig;
        this.reader = reader;
    }

    public Object readValue(InputStream is) throws IOException {
        try {
            return this.safelyReadValue(is);
        }
        catch (JacksonException e) {
            throw new IllegalArgumentException("Could not deserialize the provided message.", e);
        }
    }

    private Object safelyReadValue(InputStream is) throws IOException {
        JsonNode rootNode = this.mapper.readTree(is);
        if (this.amazonBuildTimeConfig.advancedEventHandling().enabled()) {
            if (rootNode.isObject() || rootNode.isArray()) {
                if (rootNode.isObject()) {
                    Iterator iterator;
                    ObjectNode object = (ObjectNode)rootNode;
                    if (object.has("Records") && object.get("Records").isArray() && (iterator = object.get("Records").iterator()).hasNext()) {
                        JsonNode record = (JsonNode)iterator.next();
                        return this.deserializeEvent(record, (JsonNode)object);
                    }
                } else {
                    ArrayNode array = (ArrayNode)rootNode;
                    Iterator iterator = array.iterator();
                    if (iterator.hasNext()) {
                        JsonNode record = (JsonNode)iterator.next();
                        return this.deserializeEvent(record, (JsonNode)array);
                    }
                }
            }
            log.debug((Object)"Could not detect event type. Try to deserialize to funqy method type");
        } else {
            log.debug((Object)"Advanced event handling disabled. Try to deserialize to funqy method type");
        }
        return this.deserializeFunqReturnType((TreeNode)rootNode);
    }

    public Object deserializeEvent(JsonNode record, JsonNode rootNode) throws IOException {
        Object eventClass = this.getEventType(record, rootNode);
        log.debugv("Detected event class: {0}", eventClass);
        if (eventClass != null) {
            if (eventClass instanceof Class) {
                Class clazz = (Class)eventClass;
                return this.mapper.convertValue((Object)rootNode, clazz);
            }
            if (eventClass instanceof TypeReference) {
                TypeReference typeReference = (TypeReference)eventClass;
                return this.mapper.convertValue((Object)rootNode, typeReference);
            }
        }
        log.debug((Object)"Could not detect event type. Try to deserialize to funqy method type");
        return this.deserializeFunqReturnType((TreeNode)rootNode);
    }

    private Object getEventType(JsonNode record, JsonNode object) {
        String eventSource = this.getEventSource(record);
        if (eventSource == null) {
            eventSource = "default";
        }
        Class<SNSEvent> eventType = null;
        switch (eventSource) {
            case "aws:sqs": {
                if (object.isObject()) {
                    eventType = SQSEvent.class;
                    break;
                }
                if (!object.isArray()) break;
                return new TypeReference<List<SQSEvent.SQSMessage>>(){};
            }
            case "aws:sns": {
                eventType = SNSEvent.class;
                break;
            }
            case "aws:kinesis": {
                if (object.isObject() && !object.has("window")) {
                    eventType = KinesisEvent.class;
                    break;
                }
                if (!object.isArray()) break;
                return new TypeReference<List<PipesKinesisEvent>>(){};
            }
            case "aws:dynamodb": {
                if (object.isObject()) {
                    eventType = DynamodbEvent.class;
                    break;
                }
                if (!object.isArray()) break;
                return new TypeReference<List<DynamodbEvent.DynamodbStreamRecord>>(){};
            }
        }
        if (eventType == null && this.isCloudEvent(record)) {
            return new TypeReference<List<CloudEventV1>>(){};
        }
        return eventType;
    }

    private boolean isCloudEvent(JsonNode record) {
        return record.has("specversion") && record.get("specversion").isTextual() && SpecVersion.V1.toString().equals(record.get("specversion").asText()) && record.has("type");
    }

    private String getEventSource(JsonNode record) {
        if (record.has("eventSource") && record.get("eventSource").isTextual()) {
            return record.get("eventSource").asText();
        }
        if (record.has("EventSource") && record.get("EventSource").isTextual()) {
            return record.get("EventSource").asText();
        }
        return null;
    }

    private Object deserializeFunqReturnType(TreeNode node) throws IOException {
        if (this.reader != null) {
            return this.reader.readValue(node.traverse());
        }
        return null;
    }
}

