/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.deployment.bindings;

import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.funqy.deployment.FunctionBuildItem;
import io.quarkus.funqy.deployment.FunctionInitializedBuildItem;
import io.quarkus.funqy.lambda.FunqyLambdaBindingRecorder;
import io.quarkus.funqy.lambda.config.FunqyAmazonBuildTimeConfig;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.runtime.FunqyConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import java.util.List;
import java.util.Optional;

public class FunqyLambdaBuildStep {
    public static final String FUNQY_AMAZON_LAMBDA = "funqy-amazon-lambda";

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void init(List<FunctionBuildItem> functions, FunqyLambdaBindingRecorder recorder, BuildProducer<FeatureBuildItem> feature, Optional<FunctionInitializedBuildItem> hasFunctions, LambdaObjectMapperInitializedBuildItem mapperDependency, BeanContainerBuildItem beanContainer, FunqyAmazonBuildTimeConfig buildTimeConfig) throws Exception {
        if (!hasFunctions.isPresent() || hasFunctions.get() == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem(FUNQY_AMAZON_LAMBDA));
        recorder.init(beanContainer.getValue(), buildTimeConfig);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public RuntimeComplete choose(FunqyConfig config, FunqyAmazonConfig amazonConfig, FunqyLambdaBindingRecorder recorder) {
        recorder.chooseInvoker(config, amazonConfig);
        return new RuntimeComplete();
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void startPoolLoop(FunqyLambdaBindingRecorder recorder, RuntimeComplete ignored, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem, launchModeBuildItem.getLaunchMode());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void startPoolLoopDevOrTest(RuntimeComplete ignored, FunqyLambdaBindingRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem, mode);
        }
    }

    public static final class RuntimeComplete
    extends SimpleBuildItem {
    }
}

