/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.mcp;

import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcCodec;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequest;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.runtime.mcp.DevMcpJsonRpcService;
import io.quarkus.devui.runtime.mcp.McpClientInfo;
import io.quarkus.devui.runtime.mcp.McpResponseWriter;
import io.quarkus.devui.runtime.mcp.model.InitializeResponse;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.jboss.logging.Logger;

public class McpHttpHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger((String)McpHttpHandler.class.getName());
    private final String quarkusVersion;
    private final JsonMapper jsonMapper;
    private JsonRpcCodec codec;
    private static final String SLASH = "/";
    private static final String UNDERSCORE = "_";
    private static final String CLIENT_INFO = "clientInfo";

    public McpHttpHandler(String quarkusVersion, JsonMapper jsonMapper) {
        this.quarkusVersion = quarkusVersion;
        this.jsonMapper = jsonMapper;
        this.codec = new JsonRpcCodec(jsonMapper);
    }

    public void handle(RoutingContext ctx) {
        if (ctx.request().method().equals((Object)HttpMethod.GET)) {
            this.handleSSEInitRequest(ctx);
        } else if (ctx.request().method().equals((Object)HttpMethod.POST)) {
            this.handleMCPJsonRPCRequest(ctx);
        }
    }

    private void handleSSEInitRequest(RoutingContext ctx) {
        ctx.response().setStatusCode(405).putHeader("Allow", "POST").putHeader("Content-Type", "text/plain").end("Method Not Allowed");
    }

    private void handleMCPJsonRPCRequest(RoutingContext ctx) {
        ctx.request().handler(buffer -> {
            JsonRpcRouter jsonRpcRouter = (JsonRpcRouter)CDI.current().select(JsonRpcRouter.class, new Annotation[0]).get();
            String input = buffer.toString();
            JsonRpcRequest jsonRpcRequest = this.codec.readMCPRequest(input);
            String methodName = jsonRpcRequest.getMethod();
            McpResponseWriter writer = new McpResponseWriter(ctx.response(), this.jsonMapper, methodName);
            if (methodName.equalsIgnoreCase("initialize")) {
                this.routeToMCPInitialize(jsonRpcRequest, this.codec, writer);
            } else if (methodName.startsWith("notification")) {
                this.routeToMCPNotification(jsonRpcRequest, this.codec, writer);
            } else if (methodName.equalsIgnoreCase("tools/list") || methodName.equalsIgnoreCase("resources/list") || methodName.equalsIgnoreCase("resources/read")) {
                jsonRpcRequest.setMethod(methodName.replace(SLASH, UNDERSCORE));
                jsonRpcRouter.route(jsonRpcRequest, writer);
            } else {
                jsonRpcRouter.route(jsonRpcRequest, writer);
            }
        });
    }

    private void routeToMCPInitialize(JsonRpcRequest jsonRpcRequest, JsonRpcCodec codec, McpResponseWriter writer) {
        if (jsonRpcRequest.hasParam(CLIENT_INFO)) {
            Map map = jsonRpcRequest.getParam(CLIENT_INFO, Map.class);
            DevMcpJsonRpcService devMcpJsonRpcService = (DevMcpJsonRpcService)CDI.current().select(DevMcpJsonRpcService.class, new Annotation[0]).get();
            devMcpJsonRpcService.addClientInfo(McpClientInfo.fromMap(map));
        }
        String input = this.jsonMapper.toString(jsonRpcRequest, true);
        codec.writeResponse(writer, jsonRpcRequest.getId(), new InitializeResponse(this.quarkusVersion), MessageType.Void);
    }

    private void routeToMCPNotification(JsonRpcRequest jsonRpcRequest, JsonRpcCodec codec, McpResponseWriter writer) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        String notification = jsonRpcMethodName.substring("notification".length() + 2);
        writer.getResponse().setStatusCode(202).end();
    }
}

