/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.reportissues;

import io.smallrye.common.os.OS;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Dependent
public class ReportIssuesJsonRPCService {
    private static final Logger LOG = Logger.getLogger(ReportIssuesJsonRPCService.class);
    @Inject
    @ConfigProperty(name="quarkus.devui.report-issues.url", defaultValue="https://github.com/quarkusio/quarkus/issues/new?labels=kind%2Fbug&template=bug_report.yml")
    String reportURL;

    public JsonObject reportBug() {
        URLBuilder urlBuilder = new URLBuilder(this.reportURL);
        this.gatherInfo(urlBuilder);
        return new JsonObject(Map.of("url", urlBuilder.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String run(String ... command) {
        Process process = null;
        StringBuilder responseBuilder = new StringBuilder();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command);
            process = processBuilder.start();
            try (InputStream inputStream = process.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    responseBuilder.append(line);
                    line = reader.readLine();
                }
                ReportIssuesJsonRPCService.safeWaitFor(process);
            }
            catch (Throwable t) {
                ReportIssuesJsonRPCService.safeWaitFor(process);
                throw t;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while running command: " + Arrays.toString(command)), (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
        return responseBuilder.toString();
    }

    private static void safeWaitFor(Process process) {
        boolean intr = false;
        while (true) {
            try {
                process.waitFor();
                return;
            }
            catch (InterruptedException ex) {
                intr = true;
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void gatherInfo(URLBuilder builder) {
        builder.addQueryParameter("java_version", System.getProperty("java.version")).addQueryParameter("quarkus_version", Objects.toString(this.getClass().getPackage().getImplementationVersion(), "999-SNAPSHOT"));
        if (OS.WINDOWS.isCurrent()) {
            builder.addQueryParameter("uname", this.run("cmd.exe", "/C", "ver"));
            if (ReportIssuesJsonRPCService.isMavenProject()) {
                if (Files.exists(Path.of("mvnw.cmd", new String[0]), new LinkOption[0])) {
                    builder.addQueryParameter("build_tool", this.run("./mvnw.cmd", "--version"));
                } else {
                    builder.addQueryParameter("build_tool", this.run("mvn", "--version"));
                }
            } else if (ReportIssuesJsonRPCService.isGradleProject()) {
                if (Files.exists(Path.of("gradlew.bat", new String[0]), new LinkOption[0])) {
                    builder.addQueryParameter("build_tool", this.run("./gradlew.bat", "--version"));
                } else {
                    builder.addQueryParameter("build_tool", this.run("gradle", "--version"));
                }
            }
        } else {
            builder.addQueryParameter("uname", this.run("uname", "-a"));
            if (ReportIssuesJsonRPCService.isMavenProject()) {
                if (Files.exists(Path.of("mvnw", new String[0]), new LinkOption[0])) {
                    builder.addQueryParameter("build_tool", this.run("./mvnw", "--version"));
                } else {
                    builder.addQueryParameter("build_tool", this.run("mvn", "--version"));
                }
            } else if (ReportIssuesJsonRPCService.isGradleProject()) {
                if (Files.exists(Path.of("gradlew", new String[0]), new LinkOption[0])) {
                    builder.addQueryParameter("build_tool", this.run("./gradlew", "--version"));
                } else {
                    builder.addQueryParameter("build_tool", this.run("gradle", "--version"));
                }
            }
        }
    }

    private static boolean isMavenProject() {
        return Files.exists(Path.of("pom.xml", new String[0]), new LinkOption[0]);
    }

    private static boolean isGradleProject() {
        return Files.exists(Path.of("build.gradle", new String[0]), new LinkOption[0]) || Files.exists(Path.of("build.gradle.kts", new String[0]), new LinkOption[0]);
    }

    static class URLBuilder {
        private final StringBuilder url;

        public URLBuilder(String url) {
            this.url = new StringBuilder(url);
        }

        public URLBuilder addQueryParameter(String key, String value) {
            if (this.url.indexOf("?") == -1) {
                this.url.append("?");
            } else {
                this.url.append("&");
            }
            this.url.append(URLBuilder.encodeToUTF(key).replaceAll("[+]", "%20")).append("=").append(URLBuilder.encodeToUTF(value.replaceAll(System.lineSeparator(), "%20")).replaceAll("[+]", "%20"));
            return this;
        }

        static String encodeToUTF(String value) {
            try {
                return URLEncoder.encode(value, StandardCharsets.UTF_8.displayName());
            }
            catch (UnsupportedEncodingException var2) {
                throw new RuntimeException(var2);
            }
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

