/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.extension;

import io.quarkus.devui.deployment.extension.Codestart;
import io.quarkus.devui.spi.page.Card;
import io.quarkus.devui.spi.page.LibraryLink;
import io.quarkus.devui.spi.page.Page;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Extension {
    private String namespace;
    private String artifact;
    private String name;
    private String shortName;
    private String description;
    private URL guide;
    private List<String> keywords;
    private String status;
    private List<String> configFilter;
    private List<String> categories;
    private String unlisted;
    private String builtWith;
    private List<String> providesCapabilities;
    private List<String> extensionDependencies;
    private Codestart codestart;
    private final List<Page> cardPages = new ArrayList<Page>();
    private final List<Page> menuPages = new ArrayList<Page>();
    private final List<Page> footerPages = new ArrayList<Page>();
    private Card card = null;
    private List<LibraryLink> libraryLinks = null;
    private String darkLogo = null;
    private String lightLogo = null;
    private String headlessComponent = null;
    private static final String SLASH = "/";
    private static final String DOT = ".";

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean hasLibraryLinks() {
        return this.libraryLinks != null && !this.libraryLinks.isEmpty();
    }

    public List<LibraryLink> getLibraryLinks() {
        return this.libraryLinks;
    }

    public void addLibraryLink(LibraryLink libraryLink) {
        if (this.libraryLinks == null) {
            this.libraryLinks = new LinkedList<LibraryLink>();
        }
        this.libraryLinks.add(libraryLink);
    }

    public String getDarkLogo() {
        return this.darkLogo;
    }

    public String getLightLogo() {
        return this.lightLogo;
    }

    public void setLogo(String darkLogo, String lightLogo) {
        this.darkLogo = darkLogo;
        this.lightLogo = lightLogo;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URL getGuide() {
        return this.guide;
    }

    public void setGuide(URL guide) {
        this.guide = guide;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getConfigFilter() {
        return this.configFilter;
    }

    public void setConfigFilter(List<String> configFilter) {
        this.configFilter = configFilter;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public String getUnlisted() {
        return this.unlisted;
    }

    public void setUnlisted(String unlisted) {
        this.unlisted = unlisted;
    }

    public String getBuiltWith() {
        return this.builtWith;
    }

    public void setBuiltWith(String builtWith) {
        this.builtWith = builtWith;
    }

    public List<String> getProvidesCapabilities() {
        return this.providesCapabilities;
    }

    public void setProvidesCapabilities(List<String> providesCapabilities) {
        this.providesCapabilities = providesCapabilities;
    }

    public List<String> getExtensionDependencies() {
        return this.extensionDependencies;
    }

    public void setExtensionDependencies(List<String> extensionDependencies) {
        this.extensionDependencies = extensionDependencies;
    }

    public Codestart getCodestart() {
        return this.codestart;
    }

    public void setCodestart(Codestart codestart) {
        this.codestart = codestart;
    }

    public void addCardPage(Page page) {
        this.cardPages.add(page);
    }

    public void addCardPages(List<Page> pages) {
        this.cardPages.addAll(pages);
    }

    public List<Page> getCardPages() {
        return this.cardPages;
    }

    public void addMenuPage(Page page) {
        this.menuPages.add(page);
    }

    public void addMenuPages(List<Page> pages) {
        this.menuPages.addAll(pages);
    }

    public List<Page> getMenuPages() {
        return this.menuPages;
    }

    public void addFooterPage(Page page) {
        this.footerPages.add(page);
    }

    public void addFooterPages(List<Page> pages) {
        this.footerPages.addAll(pages);
    }

    public List<Page> getFooterPages() {
        return this.footerPages;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public Card getCard() {
        return this.card;
    }

    public boolean hasCard() {
        return this.card != null;
    }

    public void setHeadlessComponent(String headlessComponent) {
        this.headlessComponent = headlessComponent;
    }

    public String getHeadlessComponent() {
        return this.headlessComponent;
    }

    public String getHeadlessComponentRef() {
        if (this.headlessComponent != null) {
            return "./../" + this.namespace + SLASH + this.headlessComponent;
        }
        return null;
    }

    public String toString() {
        return "Extension{namespace=" + this.namespace + ", artifact=" + this.artifact + ", name=" + this.name + ", shortName=" + this.shortName + ", description=" + this.description + ", guide=" + String.valueOf(this.guide) + ", keywords=" + String.valueOf(this.keywords) + ", status=" + this.status + ", configFilter=" + String.valueOf(this.configFilter) + ", categories=" + String.valueOf(this.categories) + ", unlisted=" + this.unlisted + ", builtWith=" + this.builtWith + ", providesCapabilities=" + String.valueOf(this.providesCapabilities) + ", extensionDependencies=" + String.valueOf(this.extensionDependencies) + ", codestart=" + String.valueOf(this.codestart) + "}";
    }
}

