/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.codestarts;

import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.devtools.testing.codestarts.QuarkusCodestartTest;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class QuarkusCodestartTestBuilder {
    public static final String DEFAULT_PACKAGE_FOR_TESTING = "ilove.quark.us";
    public Map<String, Object> data = new HashMap<String, Object>();
    public Collection<String> artifacts = new ArrayList<String>();
    public String packageName = "ilove.quark.us";
    public String quarkusBomGroupId;
    public String quarkusBomVersion;
    BuildTool buildTool;
    Set<String> codestarts = new HashSet<String>();
    Set<QuarkusCodestartCatalog.Language> languages;
    QuarkusCodestartCatalog quarkusCodestartCatalog;
    ExtensionCatalog extensionCatalog;
    Collection<ArtifactCoords> extensions = new ArrayList<ArtifactCoords>();

    public QuarkusCodestartTestBuilder packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public QuarkusCodestartTestBuilder codestarts(String ... codestarts) {
        this.codestarts = new HashSet<String>(Arrays.asList(codestarts));
        return this;
    }

    public QuarkusCodestartTestBuilder languages(QuarkusCodestartCatalog.Language ... languages) {
        this.languages = new HashSet<QuarkusCodestartCatalog.Language>(Arrays.asList(languages));
        return this;
    }

    public QuarkusCodestartTestBuilder buildTool(BuildTool buildTool) {
        this.buildTool = buildTool;
        return this;
    }

    public QuarkusCodestartTestBuilder putData(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public QuarkusCodestartTestBuilder putData(DataKey key, Object value) {
        this.data.put(key.key(), value);
        return this;
    }

    public QuarkusCodestartTestBuilder extensions(Collection<ArtifactCoords> extensions) {
        this.extensions.addAll(extensions);
        return this;
    }

    public QuarkusCodestartTestBuilder extension(ArtifactCoords extension) {
        this.extensions.add(extension);
        return this;
    }

    public QuarkusCodestartTestBuilder extension(ArtifactKey extension) {
        this.extensions.add(Extensions.toCoords((ArtifactKey)extension, null));
        return this;
    }

    public QuarkusCodestartTestBuilder addArtifacts(Collection<String> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    public QuarkusCodestartTestBuilder quarkusCodestartCatalog(QuarkusCodestartCatalog quarkusCodestartCatalog) {
        this.quarkusCodestartCatalog = quarkusCodestartCatalog;
        return this;
    }

    public QuarkusCodestartTestBuilder extensionCatalog(ExtensionCatalog extensionCatalog) {
        this.extensionCatalog = extensionCatalog;
        return this;
    }

    public QuarkusCodestartTestBuilder withQuarkusBomVersion(String quarkusBomVersion) {
        this.quarkusBomVersion = quarkusBomVersion;
        return this;
    }

    public QuarkusCodestartTestBuilder withQuarkusBom(String quarkusBomGroupId, String quarkusBomVersion) {
        this.quarkusBomGroupId = quarkusBomGroupId;
        this.quarkusBomVersion = quarkusBomVersion;
        return this;
    }

    public QuarkusCodestartTestBuilder setupStandaloneExtensionTest() {
        return this.setupStandaloneExtensionTest(null);
    }

    public QuarkusCodestartTestBuilder setupStandaloneExtensionTest(String extensionGA) {
        try {
            String buildWithQuarkusCoreVersion = null;
            for (URL url : Collections.list(Thread.currentThread().getContextClassLoader().getResources("META-INF/quarkus-extension.yaml"))) {
                Extension extension = (Extension)ResourceLoaders.processAsPath((URL)url, path -> {
                    try {
                        return Extension.fromFile((Path)path);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                if (extension.getArtifact() == null) {
                    throw new IllegalStateException("Artifact is null. Check that the runtime extension descriptor is built correctly with all versions defined.");
                }
                if (extensionGA != null) {
                    if (!extension.managementKey().equals(extensionGA)) continue;
                    this.extension(extension.getArtifact());
                    buildWithQuarkusCoreVersion = ExtensionProcessor.getBuiltWithQuarkusCore((Extension)extension);
                    break;
                }
                if (buildWithQuarkusCoreVersion != null) continue;
                buildWithQuarkusCoreVersion = ExtensionProcessor.getBuiltWithQuarkusCore((Extension)extension);
                break;
            }
            Objects.requireNonNull(buildWithQuarkusCoreVersion, "quarkus version not found in extensions");
            this.quarkusBomVersion = buildWithQuarkusCoreVersion;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while reading standalone extension catalog", e);
        }
        return this;
    }

    @Deprecated(forRemoval=true)
    public QuarkusCodestartTestBuilder standaloneExtensionCatalog(String quarkusBomGroupId, String quarkusBomVersion) {
        this.quarkusBomGroupId = quarkusBomGroupId;
        this.quarkusBomVersion = quarkusBomVersion;
        return this;
    }

    @Deprecated
    public QuarkusCodestartTestBuilder standaloneExtensionCatalog() {
        return this.setupStandaloneExtensionTest();
    }

    public QuarkusCodestartTest build() {
        return new QuarkusCodestartTest(this);
    }
}

