/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing;

import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.testing.registry.client.TestRegistryClientBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class RegistryClientTestHelper {
    public static void enableRegistryClientTestConfig(String quarkusBomGroupId, String quarkusBomVersion) {
        RegistryClientTestHelper.enableRegistryClientTestConfig(RegistryClientTestHelper.getConfigBaseDir(), System.getProperties(), quarkusBomGroupId, quarkusBomVersion);
    }

    public static void enableRegistryClientTestConfig() {
        RegistryClientTestHelper.enableRegistryClientTestConfig(System.getProperties());
    }

    public static void enableRegistryClientTestConfig(Properties properties) {
        RegistryClientTestHelper.enableRegistryClientTestConfig(RegistryClientTestHelper.getConfigBaseDir(), properties);
    }

    private static Path getConfigBaseDir() {
        return Paths.get("", new String[0]).normalize().toAbsolutePath().resolve("target");
    }

    public static void enableRegistryClientTestConfig(Path outputDir, Properties properties) {
        String quarkusBomVersion = System.getProperty("project.version");
        String quarkusBomGroupId = System.getProperty("project.groupId");
        RegistryClientTestHelper.enableRegistryClientTestConfig(outputDir, properties, quarkusBomGroupId, quarkusBomVersion);
    }

    public static void enableRegistryClientTestConfig(Path outputDir, Properties properties, String quarkusBomGroupId, String quarkusBomVersion) {
        if (quarkusBomVersion == null) {
            throw new IllegalStateException("quarkusBomVersion isn't set");
        }
        if (quarkusBomGroupId == null) {
            throw new IllegalStateException("quarkusBomGroupId isn't set");
        }
        Path toolsConfigPath = outputDir.resolve(".quarkus/config.yaml");
        ArtifactCoords bom = ArtifactCoords.pom((String)quarkusBomGroupId, (String)"quarkus-bom", (String)quarkusBomVersion);
        TestRegistryClientBuilder.newInstance().baseDir(toolsConfigPath.getParent()).newRegistry("test.quarkus.registry").newPlatform(bom.getGroupId()).newStream(quarkusBomVersion).newRelease(quarkusBomVersion).quarkusVersion(quarkusBomVersion).addMemberBom(bom).registry().clientBuilder().build();
        RegistryClientTestHelper.enableExistingConfig(properties, toolsConfigPath);
    }

    public static void reenableRegistryClientTestConfig() {
        Path toolsConfigPath = RegistryClientTestHelper.getConfigBaseDir().resolve(".quarkus/config.yaml");
        if (Files.exists(toolsConfigPath, new LinkOption[0])) {
            RegistryClientTestHelper.enableExistingConfig(System.getProperties(), toolsConfigPath);
        }
        RegistryClientTestHelper.enableRegistryClientTestConfig();
    }

    private static void enableExistingConfig(Properties properties, Path toolsConfigPath) {
        properties.setProperty("quarkus.tools.config", toolsConfigPath.toString());
        properties.setProperty("quarkusRegistryClient", "true");
        QuarkusProjectHelper.reset();
    }

    public static void disableRegistryClientTestConfig() {
        RegistryClientTestHelper.disableRegistryClientTestConfig(System.getProperties());
    }

    public static void disableRegistryClientTestConfig(Properties properties) {
        properties.remove("quarkus.tools.config");
        properties.remove("quarkusRegistryClient");
    }
}

