/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.client.RegistryNonPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenNonPlatformExtensionsResolver
implements RegistryNonPlatformExtensionsResolver {
    private final RegistryNonPlatformExtensionsConfig config;
    private final MavenRegistryArtifactResolver artifactResolver;
    private final MessageWriter log;

    public MavenNonPlatformExtensionsResolver(RegistryNonPlatformExtensionsConfig config, MavenRegistryArtifactResolver artifactResolver, MessageWriter log) {
        this.config = Objects.requireNonNull(config);
        this.artifactResolver = Objects.requireNonNull(artifactResolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public ExtensionCatalog.Mutable resolveNonPlatformExtensions(String quarkusVersion) throws RegistryResolutionException {
        Path jsonFile;
        ArtifactCoords baseCoords = this.config.getArtifact();
        DefaultArtifact catalogArtifact = new DefaultArtifact(baseCoords.getGroupId(), baseCoords.getArtifactId(), quarkusVersion, baseCoords.getType(), baseCoords.getVersion());
        this.log.debug("Resolving non-platform extension catalog %s", new Object[]{catalogArtifact});
        try {
            jsonFile = this.artifactResolver.resolve((Artifact)catalogArtifact);
        }
        catch (Exception e) {
            this.log.debug("Failed to resolve non-platform extension catalog %s", new Object[]{catalogArtifact});
            return null;
        }
        try {
            return ExtensionCatalog.mutableFromFile(jsonFile);
        }
        catch (Exception e) {
            throw new RegistryResolutionException("Failed to load non-platform extension catalog from " + String.valueOf(jsonFile), e);
        }
    }
}

