/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.project.update.PlatformInfo;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.List;
import java.util.Map;

public class ProjectPlatformUpdateInfo {
    private final Map<ArtifactKey, PlatformInfo> platformImports;
    private final List<PlatformInfo> importVersionUpdates;
    private final List<PlatformInfo> newImports;
    private final boolean importsToBeRemoved;
    private final boolean platformUpdatesAvailable;

    public ProjectPlatformUpdateInfo(Map<ArtifactKey, PlatformInfo> platformImports, List<PlatformInfo> importVersionUpdates, List<PlatformInfo> newImports) {
        this.platformImports = platformImports;
        this.importVersionUpdates = importVersionUpdates;
        this.newImports = newImports;
        this.importsToBeRemoved = platformImports.values().stream().anyMatch(p -> p.getRecommended() == null);
        this.platformUpdatesAvailable = !importVersionUpdates.isEmpty() || !newImports.isEmpty() || this.importsToBeRemoved;
    }

    public boolean isImportsToBeRemoved() {
        return this.importsToBeRemoved;
    }

    public boolean isPlatformUpdatesAvailable() {
        return this.platformUpdatesAvailable;
    }

    public Map<ArtifactKey, PlatformInfo> getPlatformImports() {
        return this.platformImports;
    }

    public List<PlatformInfo> getImportVersionUpdates() {
        return this.importVersionUpdates;
    }

    public List<PlatformInfo> getNewImports() {
        return this.newImports;
    }
}

