/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.exec;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.utilities.OS;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Executable {
    public static File findExecutableFile(String base) {
        String path = null;
        Object executable = base;
        if (OS.determineOS() == OS.WINDOWS) {
            executable = base + ".cmd";
            path = Executable.findExecutable((String)executable);
            if (path == null) {
                executable = base + ".bat";
                path = Executable.findExecutable((String)executable);
            }
        } else {
            executable = base;
            path = Executable.findExecutable((String)executable);
        }
        if (path == null) {
            return null;
        }
        return new File(path, (String)executable);
    }

    public static String findExecutable(String exec) {
        return Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).map(path -> path.resolve(exec).toFile()).filter(File::exists).findFirst().map(File::getParent).orElse(null);
    }

    public static File findExecutable(String name, String errorMessage, MessageWriter output) {
        File command = Executable.findExecutableFile(name);
        if (command == null) {
            output.error(errorMessage);
            throw new RuntimeException("Unable to find " + name + " command");
        }
        return command;
    }

    public static File findWrapper(Path projectRoot, String[] windows, String other) {
        Path normalizedPath;
        if (projectRoot == null) {
            return null;
        }
        if (OS.determineOS() == OS.WINDOWS) {
            for (String name : windows) {
                File wrapper = new File(projectRoot + File.separator + name);
                if (!wrapper.isFile()) continue;
                return wrapper;
            }
        } else {
            File wrapper = new File(projectRoot + File.separator + other);
            if (wrapper.isFile()) {
                return wrapper;
            }
        }
        if (!(normalizedPath = projectRoot.normalize()).equals(projectRoot.getRoot())) {
            return Executable.findWrapper(normalizedPath.getParent(), windows, other);
        }
        return null;
    }
}

