/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment;

import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.devservices.ContainerInfo;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devservices.deployment.ContainerLogForwarder;
import io.quarkus.devservices.deployment.DevServicesCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aesh.command.Command;
import org.testcontainers.DockerClientFactory;

public class DevServicesProcessor {
    private static final String EXEC_FORMAT = "%s exec -it %s /bin/bash";
    static volatile ConsoleStateManager.ConsoleContext context;
    static volatile boolean logForwardEnabled;
    static Map<String, ContainerLogForwarder> containerLogForwarders;

    @BuildStep(onlyIf={IsDevelopment.class})
    public List<DevServiceDescriptionBuildItem> config(DockerStatusBuildItem dockerStatusBuildItem, BuildProducer<ConsoleCommandBuildItem> commandBuildItemBuildProducer, LaunchModeBuildItem launchModeBuildItem, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, List<DevServicesResultBuildItem> devServicesResults) {
        List<DevServiceDescriptionBuildItem> serviceDescriptions = this.buildServiceDescriptions(dockerStatusBuildItem, devServicesResults, devServicesLauncherConfig);
        for (DevServiceDescriptionBuildItem devService : serviceDescriptions) {
            if (!devService.hasContainerInfo()) continue;
            containerLogForwarders.compute(devService.getContainerInfo().getId(), (id, forwarder) -> Objects.requireNonNullElseGet(forwarder, () -> new ContainerLogForwarder(devService)));
        }
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return serviceDescriptions;
        }
        commandBuildItemBuildProducer.produce((BuildItem)new ConsoleCommandBuildItem((Command)new DevServicesCommand(serviceDescriptions)));
        if (context == null) {
            context = ConsoleStateManager.INSTANCE.createContext("Dev Services");
        }
        context.reset(new ConsoleCommand[]{new ConsoleCommand('c', "Show Dev Services containers", null, () -> {
            List<DevServiceDescriptionBuildItem> descriptions = this.buildServiceDescriptions(dockerStatusBuildItem, devServicesResults, devServicesLauncherConfig);
            StringBuilder builder = new StringBuilder();
            builder.append("\n\n").append("\u001b[91m==\u001b[39m \u001b[4mDev Services\u001b[24m").append("\n\n");
            for (DevServiceDescriptionBuildItem devService : descriptions) {
                DevServicesProcessor.printDevService(builder, devService, true);
                builder.append("\n");
            }
            System.out.println(builder);
        }), new ConsoleCommand('g', "Follow Dev Services logs in the console", new ConsoleCommand.HelpState(() -> logForwardEnabled ? "\u001b[32m" : "\u001b[91m", () -> logForwardEnabled ? "enabled" : "disabled"), this::toggleLogForwarders)});
        return serviceDescriptions;
    }

    private List<DevServiceDescriptionBuildItem> buildServiceDescriptions(DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesResultBuildItem> devServicesResults, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        Set<String> containerIds = devServicesResults.stream().map(DevServicesResultBuildItem::getContainerId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, Container> containerInfos = this.fetchContainerInfos(dockerStatusBuildItem, containerIds);
        HashSet configKeysFromDevServices = new HashSet();
        ArrayList<DevServiceDescriptionBuildItem> descriptions = new ArrayList<DevServiceDescriptionBuildItem>();
        for (DevServicesResultBuildItem buildItem : devServicesResults) {
            configKeysFromDevServices.addAll(buildItem.getConfig().keySet());
            descriptions.add(this.toDevServiceDescription(buildItem, containerInfos.get(buildItem.getContainerId())));
        }
        descriptions.sort(Comparator.comparing(DevServiceDescriptionBuildItem::getName));
        if (devServicesLauncherConfig.isPresent()) {
            TreeMap config = new TreeMap(devServicesLauncherConfig.get().getConfig());
            for (String key : configKeysFromDevServices) {
                config.remove(key);
            }
            if (!config.isEmpty()) {
                descriptions.add(new DevServiceDescriptionBuildItem("Additional Dev Services config", null, config));
            }
        }
        return descriptions;
    }

    private Map<String, Container> fetchContainerInfos(DockerStatusBuildItem dockerStatusBuildItem, Set<String> containerIds) {
        if (containerIds.isEmpty() || !dockerStatusBuildItem.isDockerAvailable()) {
            return Collections.emptyMap();
        }
        return ((List)DockerClientFactory.lazyClient().listContainersCmd().withIdFilter(containerIds).withShowAll(Boolean.valueOf(true)).exec()).stream().collect(Collectors.toMap(Container::getId, Function.identity()));
    }

    private DevServiceDescriptionBuildItem toDevServiceDescription(DevServicesResultBuildItem buildItem, Container container) {
        if (container == null) {
            return new DevServiceDescriptionBuildItem(buildItem.getName(), null, buildItem.getConfig());
        }
        return new DevServiceDescriptionBuildItem(buildItem.getName(), this.toContainerInfo(container), buildItem.getConfig());
    }

    private ContainerInfo toContainerInfo(Container container) {
        return new ContainerInfo(container.getId(), container.getNames(), container.getImage(), container.getStatus(), DevServicesProcessor.getNetworks(container), container.getLabels(), this.getExposedPorts(container));
    }

    private static String[] getNetworks(Container container) {
        ContainerNetworkSettings networkSettings = container.getNetworkSettings();
        if (networkSettings == null) {
            return null;
        }
        Map networks = networkSettings.getNetworks();
        if (networks == null) {
            return null;
        }
        return (String[])networks.entrySet().stream().map(e -> {
            List aliases = ((ContainerNetwork)e.getValue()).getAliases();
            if (aliases == null) {
                return (String)e.getKey();
            }
            return (String)e.getKey() + " (" + String.join((CharSequence)",", aliases) + ")";
        }).toArray(String[]::new);
    }

    private ContainerInfo.ContainerPort[] getExposedPorts(Container container) {
        return (ContainerInfo.ContainerPort[])Arrays.stream(container.getPorts()).map(c -> new ContainerInfo.ContainerPort(c.getIp(), c.getPrivatePort(), c.getPublicPort(), c.getType())).toArray(ContainerInfo.ContainerPort[]::new);
    }

    private synchronized void toggleLogForwarders() {
        if (logForwardEnabled) {
            for (ContainerLogForwarder logForwarder : containerLogForwarders.values()) {
                if (!logForwarder.isRunning()) continue;
                logForwarder.close();
            }
            logForwardEnabled = false;
        } else {
            for (ContainerLogForwarder logForwarder : containerLogForwarders.values()) {
                logForwarder.start();
            }
            logForwardEnabled = true;
        }
    }

    public static void printDevService(StringBuilder builder, DevServiceDescriptionBuildItem devService, boolean withStatus) {
        builder.append("\u001b[1m").append(devService.getName()).append("\u001b[22m");
        builder.append("\n");
        if (devService.hasContainerInfo()) {
            builder.append(String.format("  %-18s", "Container: ")).append(devService.getContainerInfo().getId(), 0, 12).append(devService.getContainerInfo().formatNames()).append("  ").append(devService.getContainerInfo().getImageName()).append("\n");
            builder.append(String.format("  %-18s", "Network: ")).append(devService.getContainerInfo().formatNetworks()).append(" - ").append(devService.getContainerInfo().formatPorts()).append("\n");
            ContainerRuntimeUtil.ContainerRuntime containerRuntime = ContainerRuntimeUtil.detectContainerRuntime((boolean)false);
            if (containerRuntime != null) {
                builder.append(String.format("  %-18s", "Exec command: ")).append(String.format(EXEC_FORMAT, containerRuntime.getExecutableName(), devService.getContainerInfo().getShortId())).append("\n");
            }
        }
        if (!devService.getConfigs().isEmpty()) {
            builder.append(String.format("  %-18s", "Injected config: "));
            boolean indent = false;
            for (Map.Entry devServiceConfigEntry : devService.getConfigs().entrySet()) {
                if (indent) {
                    builder.append(String.format("  %-18s", " "));
                }
                builder.append(String.format("- %s=%s\n", devServiceConfigEntry.getKey(), devServiceConfigEntry.getValue()));
                indent = true;
            }
        }
    }

    static {
        logForwardEnabled = false;
        containerLogForwarders = new HashMap<String, ContainerLogForwarder>();
    }
}

