/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment;

import com.github.dockerjava.api.async.ResultCallback;
import io.quarkus.deployment.dev.devservices.ContainerInfo;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import java.io.Closeable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;

public class ContainerLogForwarder
implements Closeable {
    private final DevServiceDescriptionBuildItem devService;
    private final AtomicLong timestamp = new AtomicLong(0L);
    private final Logger logger;
    private FrameConsumerResultCallback resultCallback;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ContainerLogForwarder(DevServiceDescriptionBuildItem devService) {
        this.devService = devService;
        this.logger = Logger.getLogger((String)devService.getName());
    }

    public DevServiceDescriptionBuildItem getDevService() {
        return this.devService;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void start() {
        ContainerInfo containerInfo = this.devService.getContainerInfo();
        if (containerInfo != null) {
            String shortId = containerInfo.getShortId();
            if (this.running.compareAndSet(false, true)) {
                this.resultCallback = new FrameConsumerResultCallback();
                this.resultCallback.addConsumer(OutputFrame.OutputType.STDOUT, frame -> {
                    if (this.running.get()) {
                        this.logger.infof("[%s] %s", (Object)shortId, (Object)this.updateTimestamp((OutputFrame)frame));
                    }
                });
                this.resultCallback.addConsumer(OutputFrame.OutputType.STDERR, frame -> {
                    if (this.running.get()) {
                        this.logger.errorf("[%s] %s", (Object)shortId, (Object)this.updateTimestamp((OutputFrame)frame));
                    }
                });
                DockerClientFactory.lazyClient().logContainerCmd(containerInfo.id()).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withSince(Integer.valueOf(this.timestamp.intValue())).exec((ResultCallback)this.resultCallback);
            }
        }
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.resultCallback.close();
            }
            catch (Throwable throwable) {
                this.logger.errorf("Failed to close log forwarder %s", (Object)this.devService.getName());
            }
            finally {
                this.resultCallback = null;
            }
        }
    }

    private String updateTimestamp(OutputFrame frame) {
        this.timestamp.set(Instant.now().getEpochSecond());
        return frame.getUtf8String().trim();
    }
}

