/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevServicesSupportedByLaunchMode;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.ApplicationInstanceIdBuildItem;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesCustomizerBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesNetworkIdBuildItem;
import io.quarkus.deployment.builditem.DevServicesRegistryBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.devservices.ContainerInfo;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devservice.runtime.config.DevServicesConfigBuilder;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerUtil;
import io.quarkus.devservices.common.StartableContainer;
import io.quarkus.devservices.crossclassloader.runtime.RunningService;
import io.quarkus.devservices.deployment.ContainerLogForwarder;
import io.quarkus.devservices.deployment.DevServicesCommand;
import io.quarkus.devui.spi.buildtime.FooterLogBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.Supplier;
import org.aesh.command.Command;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;

public class DevServicesProcessor {
    private static final String EXEC_FORMAT = "%s exec -it %s /bin/bash";
    static volatile ConsoleStateManager.ConsoleContext context;
    static volatile boolean logForwardEnabled;
    static Set<ContainerLogForwarder> containerLogForwarders;

    @BuildStep
    public DevServicesNetworkIdBuildItem networkId(Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, Optional<DevServicesComposeProjectBuildItem> composeProjectBuildItem) {
        String networkId = composeProjectBuildItem.map(DevServicesComposeProjectBuildItem::getDefaultNetworkId).or(() -> devServicesLauncherConfig.flatMap(ignored -> this.getSharedNetworkId())).orElse(null);
        return new DevServicesNetworkIdBuildItem(networkId);
    }

    @BuildStep(onlyIf={IsDevServicesSupportedByLaunchMode.class})
    @Produce(value=ServiceStartBuildItem.class)
    public DevServicesCustomizerBuildItem containerCustomizer(LaunchModeBuildItem launchModeBuildItem, DevServicesConfig globalDevServicesConfig) {
        return new DevServicesCustomizerBuildItem((devService, startable) -> {
            LaunchMode launchMode = launchModeBuildItem.getLaunchMode();
            if (startable instanceof StartableContainer) {
                StartableContainer startableContainer = (StartableContainer)startable;
                GenericContainer container = startableContainer.getContainer();
                ConfigureUtil.configureLabels((GenericContainer)container, (LaunchMode)launchMode);
                if (ConfigureUtil.shouldConfigureSharedServiceLabel((LaunchMode)launchMode)) {
                    container.withLabel("io.quarkus.devservice", devService.getServiceName());
                }
                globalDevServicesConfig.timeout().ifPresent(arg_0 -> ((GenericContainer)container).withStartupTimeout(arg_0));
            } else if (startable instanceof GenericContainer) {
                GenericContainer container = (GenericContainer)startable;
                ConfigureUtil.configureLabels((GenericContainer)container, (LaunchMode)launchMode);
                globalDevServicesConfig.timeout().ifPresent(arg_0 -> ((GenericContainer)container).withStartupTimeout(arg_0));
                if (ConfigureUtil.shouldConfigureSharedServiceLabel((LaunchMode)launchMode)) {
                    container.withLabel("io.quarkus.devservice", devService.getServiceName());
                }
            }
            return startable;
        });
    }

    private Optional<String> getSharedNetworkId() {
        try {
            Field id;
            Object sharedNetwork;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl.getName().contains("Deployment")) {
                Class<?> networkClass = tccl.getParent().loadClass("org.testcontainers.containers.Network");
                sharedNetwork = networkClass.getField("SHARED").get(null);
                Class<?> networkImplClass = tccl.getParent().loadClass("org.testcontainers.containers.Network$NetworkImpl");
                id = networkImplClass.getDeclaredField("id");
            } else {
                sharedNetwork = Network.SHARED;
                id = Network.NetworkImpl.class.getDeclaredField("id");
            }
            id.setAccessible(true);
            String value = (String)id.get(sharedNetwork);
            return Optional.ofNullable(value);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @BuildStep(onlyIf={IsDevServicesSupportedByLaunchMode.class})
    @Produce(value=ServiceStartBuildItem.class)
    DevServicesRegistryBuildItem devServicesRegistry(LaunchModeBuildItem launchMode, ApplicationInstanceIdBuildItem applicationId, DevServicesConfig globalDevServicesConfig, CuratedApplicationShutdownBuildItem shutdownBuildItem) {
        DevServicesRegistryBuildItem registryBuildItem = new DevServicesRegistryBuildItem(applicationId.getUUID(), globalDevServicesConfig, launchMode.getLaunchMode());
        shutdownBuildItem.addCloseTask(() -> ((DevServicesRegistryBuildItem)registryBuildItem).closeAllRunningServices(), true);
        return registryBuildItem;
    }

    @BuildStep
    public RunTimeConfigBuilderBuildItem registerDevResourcesConfigSource(List<DevServicesResultBuildItem> devServicesRequestBuildItems) {
        return new RunTimeConfigBuilderBuildItem(DevServicesConfigBuilder.class);
    }

    @BuildStep(onlyIf={IsDevelopment.class, DevServicesConfig.Enabled.class})
    public List<DevServiceDescriptionBuildItem> config(DockerStatusBuildItem dockerStatusBuildItem, BuildProducer<ConsoleCommandBuildItem> commandBuildItemBuildProducer, BuildProducer<FooterLogBuildItem> footerLogProducer, LaunchModeBuildItem launchModeBuildItem, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, List<DevServicesResultBuildItem> devServicesResults, DevServicesRegistryBuildItem devServicesRegistry) {
        containerLogForwarders.clear();
        boolean isContainerRuntimeAvailable = dockerStatusBuildItem.isContainerRuntimeAvailable();
        List<DevServiceDescriptionBuildItem> serviceDescriptions = this.buildServiceDescriptions(isContainerRuntimeAvailable, devServicesResults, devServicesRegistry, devServicesLauncherConfig);
        for (DevServiceDescriptionBuildItem devService : serviceDescriptions) {
            containerLogForwarders.add(new ContainerLogForwarder(devService));
        }
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return serviceDescriptions;
        }
        commandBuildItemBuildProducer.produce((BuildItem)new ConsoleCommandBuildItem((Command)new DevServicesCommand(serviceDescriptions)));
        for (DevServiceDescriptionBuildItem service : serviceDescriptions) {
            footerLogProducer.produce((BuildItem)new FooterLogBuildItem(service.getName(), () -> {
                ContainerInfo containerInfo = service.getContainerInfo();
                return this.createLogPublisher(containerInfo);
            }));
        }
        if (context == null) {
            context = ConsoleStateManager.INSTANCE.createContext("Dev Services");
        }
        context.reset(new ConsoleCommand[]{new ConsoleCommand('c', "Show Dev Services containers", null, () -> {
            List<DevServiceDescriptionBuildItem> descriptions = this.buildServiceDescriptions(isContainerRuntimeAvailable, devServicesResults, devServicesRegistry, devServicesLauncherConfig);
            StringBuilder builder = new StringBuilder();
            builder.append("\n\n").append("\u001b[91m==\u001b[39m \u001b[4mDev Services\u001b[24m").append("\n\n");
            for (DevServiceDescriptionBuildItem devService : descriptions) {
                DevServicesProcessor.printDevService(builder, devService, true);
                builder.append("\n");
            }
            System.out.println(builder);
        }), new ConsoleCommand('g', "Follow Dev Services logs in the console", new ConsoleCommand.HelpState(() -> logForwardEnabled ? "\u001b[32m" : "\u001b[91m", () -> logForwardEnabled ? "enabled" : "disabled"), this::toggleLogForwarders)});
        return serviceDescriptions;
    }

    private Flow.Publisher<String> createLogPublisher(ContainerInfo containerInfo) {
        SubmissionPublisher<String> submissionPublisher;
        FrameConsumerResultCallback resultCallback = new FrameConsumerResultCallback();
        try {
            SubmissionPublisher<String> publisher = new SubmissionPublisher<String>();
            resultCallback.addConsumer(OutputFrame.OutputType.STDERR, frame -> publisher.submit(frame.getUtf8String()));
            resultCallback.addConsumer(OutputFrame.OutputType.STDOUT, frame -> publisher.submit(frame.getUtf8String()));
            if (containerInfo != null) {
                String containerId = containerInfo.id();
                LogContainerCmd logCmd = DockerClientFactory.lazyClient().logContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withTailAll().withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true));
                logCmd.exec((ResultCallback)resultCallback);
            }
            submissionPublisher = publisher;
        }
        catch (Throwable throwable) {
            try {
                try {
                    resultCallback.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        resultCallback.close();
        return submissionPublisher;
    }

    private List<DevServiceDescriptionBuildItem> buildServiceDescriptions(boolean isContainerRuntimeAvailable, List<DevServicesResultBuildItem> devServicesResults, DevServicesRegistryBuildItem devServicesRegistry, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        HashSet configKeysFromDevServices = new HashSet();
        ArrayList<DevServiceDescriptionBuildItem> descriptions = new ArrayList<DevServiceDescriptionBuildItem>();
        for (DevServicesResultBuildItem buildItem : devServicesResults) {
            configKeysFromDevServices.addAll(buildItem.getConfig().keySet());
            descriptions.add(this.toDevServiceDescription(buildItem, () -> ((DevServicesResultBuildItem)buildItem).getContainerId(), isContainerRuntimeAvailable, devServicesRegistry));
        }
        descriptions.sort(Comparator.comparing(DevServiceDescriptionBuildItem::getName));
        if (devServicesLauncherConfig.isPresent()) {
            TreeMap config = new TreeMap(devServicesLauncherConfig.get().getConfig());
            for (String key : configKeysFromDevServices) {
                config.remove(key);
            }
            if (!config.isEmpty()) {
                descriptions.add(new DevServiceDescriptionBuildItem("Additional Dev Services config", config));
            }
        }
        return descriptions;
    }

    private Optional<Container> fetchContainerInfo(String containerId, boolean isContainerRuntimeAvailable) {
        if (containerId == null || !isContainerRuntimeAvailable) {
            return Optional.empty();
        }
        return ((List)DockerClientFactory.lazyClient().listContainersCmd().withIdFilter(Collections.singleton(containerId)).withShowAll(Boolean.valueOf(true)).exec()).stream().findAny();
    }

    private DevServiceDescriptionBuildItem toDevServiceDescription(DevServicesResultBuildItem buildItem, Supplier<String> containerIdFun, boolean isContainerRuntimeAvailable, DevServicesRegistryBuildItem devServicesRegistry) {
        if (!buildItem.isStartable()) {
            return new DevServiceDescriptionBuildItem(buildItem.getName(), buildItem.getDescription(), this.toContainerInfo(containerIdFun, isContainerRuntimeAvailable), buildItem.getConfig());
        }
        return new DevServiceDescriptionBuildItem(buildItem.getName(), buildItem.getDescription(), this.toContainerInfo(() -> {
            RunningService runningService = devServicesRegistry.getRunningServices(buildItem.getName(), buildItem.getServiceName(), buildItem.getServiceConfig());
            return runningService == null ? null : runningService.containerId();
        }, isContainerRuntimeAvailable), () -> {
            RunningService runningService = devServicesRegistry.getRunningServices(buildItem.getName(), buildItem.getServiceName(), buildItem.getServiceConfig());
            return runningService == null ? null : runningService.configs();
        });
    }

    private Supplier<ContainerInfo> toContainerInfo(Supplier<String> containerIdFun, boolean isContainerRuntimeAvailable) {
        return () -> {
            Optional<Container> maybeContainer;
            String containerId = (String)containerIdFun.get();
            if (containerId != null && (maybeContainer = this.fetchContainerInfo(containerId, isContainerRuntimeAvailable)).isPresent()) {
                Container container = maybeContainer.get();
                return new ContainerInfo(container.getId(), container.getNames(), container.getImage(), container.getStatus(), DevServicesProcessor.getNetworks(container), container.getLabels(), this.getExposedPorts(container));
            }
            return null;
        };
    }

    private static Map<String, String[]> getNetworks(Container container) {
        ContainerNetworkSettings networkSettings = container.getNetworkSettings();
        if (networkSettings == null) {
            return null;
        }
        return ContainerUtil.getNetworks((Map)networkSettings.getNetworks());
    }

    private ContainerInfo.ContainerPort[] getExposedPorts(Container container) {
        return (ContainerInfo.ContainerPort[])Arrays.stream(container.getPorts()).map(c -> new ContainerInfo.ContainerPort(c.getIp(), c.getPrivatePort(), c.getPublicPort(), c.getType())).toArray(ContainerInfo.ContainerPort[]::new);
    }

    private synchronized void toggleLogForwarders() {
        if (logForwardEnabled) {
            for (ContainerLogForwarder logForwarder : containerLogForwarders) {
                if (!logForwarder.isRunning()) continue;
                logForwarder.close();
            }
            logForwardEnabled = false;
        } else {
            for (ContainerLogForwarder logForwarder : containerLogForwarders) {
                logForwarder.start();
            }
            logForwardEnabled = true;
        }
    }

    public static void printDevService(StringBuilder builder, DevServiceDescriptionBuildItem devService, boolean withStatus) {
        builder.append("\u001b[1m").append(devService.getName()).append("\u001b[22m");
        builder.append("\n");
        ContainerInfo containerInfo = devService.getContainerInfo();
        if (containerInfo != null) {
            builder.append(String.format("  %-18s", "Container: ")).append(containerInfo.id(), 0, 12).append(containerInfo.formatNames()).append("  ").append(containerInfo.imageName()).append("\n");
            builder.append(String.format("  %-18s", "Network: ")).append(containerInfo.formatNetworks()).append(" - ").append(containerInfo.formatPorts()).append("\n");
            ContainerRuntimeUtil.ContainerRuntime containerRuntime = ContainerRuntimeUtil.detectContainerRuntime((boolean)false, (ContainerRuntimeUtil.ContainerRuntime[])new ContainerRuntimeUtil.ContainerRuntime[0]);
            if (containerRuntime != null) {
                builder.append(String.format("  %-18s", "Exec command: ")).append(String.format(EXEC_FORMAT, containerRuntime.getExecutableName(), containerInfo.getShortId())).append("\n");
            }
        }
        if (!devService.getConfigs().isEmpty()) {
            builder.append(String.format("  %-18s", "Injected config: "));
            boolean indent = false;
            for (Map.Entry devServiceConfigEntry : devService.getConfigs().entrySet()) {
                if (indent) {
                    builder.append(String.format("  %-18s", " "));
                }
                builder.append(String.format("- %s=%s\n", devServiceConfigEntry.getKey(), devServiceConfigEntry.getValue()));
                indent = true;
            }
        }
    }

    static {
        logForwardEnabled = false;
        containerLogForwarders = new HashSet<ContainerLogForwarder>();
    }
}

