/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import io.smallrye.common.process.ProcessBuilder;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.utility.CommandLine;

public class ComposeRunner {
    private static final Logger LOG = Logger.getLogger(ComposeRunner.class);
    private static final String DOCKER_HOST_ENV = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH_ENV = "DOCKER_CERT_PATH";
    private static final String DOCKER_TLS_VERIFY_ENV = "DOCKER_TLS_VERIFY";
    private static final String PROJECT_NAME_ENV = "COMPOSE_PROJECT_NAME";
    private static final String COMPOSE_FILE_ENV = "COMPOSE_FILE";
    private static final String COMPOSE_PROFILES_ENV = "COMPOSE_PROFILES";
    private final List<File> composeFiles;
    private final String identifier;
    private final String composeExecutable;
    private String cmd;
    private Map<String, String> env;
    private List<String> profiles;

    public ComposeRunner(String composeExecutable, List<File> composeFiles, String projectName) {
        this.composeExecutable = composeExecutable;
        this.composeFiles = composeFiles;
        this.identifier = projectName;
        this.cmd = "";
        this.env = Collections.emptyMap();
        this.profiles = Collections.emptyList();
    }

    public ComposeRunner withCommand(String cmd) {
        this.cmd = cmd;
        return this;
    }

    public ComposeRunner withEnv(Map<String, String> env) {
        this.env = Collections.unmodifiableMap(env);
        return this;
    }

    public ComposeRunner withProfiles(List<String> profiles) {
        this.profiles = Collections.unmodifiableList(profiles);
        return this;
    }

    public void run() {
        if (!CommandLine.executableExists((String)this.composeExecutable)) {
            throw new RuntimeException("Docker Compose not found. Is " + this.composeExecutable + " on the PATH?");
        }
        if (this.composeFiles.isEmpty()) {
            LOG.info((Object)"No compose files specified");
            return;
        }
        LOG.infov("Compose is running command: {0} {1}", (Object)this.composeExecutable, (Object)this.cmd);
        File pwd = this.composeFiles.get(0).getAbsoluteFile().getParentFile().getAbsoluteFile();
        ProcessBuilder.newBuilder((String)this.composeExecutable).directory(pwd.toPath()).arguments(this.cmd.split("\\s+")).environment(this.env).modifyEnvironment(env -> {
            env.put(PROJECT_NAME_ENV, this.identifier);
            TransportConfig transportConfig = DockerClientFactory.instance().getTransportConfig();
            String certPath = System.getenv(DOCKER_CERT_PATH_ENV);
            if (certPath != null) {
                env.put(DOCKER_CERT_PATH_ENV, certPath);
                env.put(DOCKER_TLS_VERIFY_ENV, "true");
            }
            env.put(DOCKER_HOST_ENV, transportConfig.getDockerHost().toString());
            env.put(COMPOSE_FILE_ENV, this.composeFiles.stream().map(File::getAbsolutePath).map(Objects::toString).collect(Collectors.joining(File.pathSeparator)));
            if (!this.profiles.isEmpty()) {
                env.put(COMPOSE_PROFILES_ENV, String.join((CharSequence)",", this.profiles));
            }
        }).output().consumeLinesWith(8192, arg_0 -> ((Logger)LOG).info(arg_0)).run();
        LOG.info((Object)"Compose has finished running");
    }
}

