/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.dev.console.QuarkusConsole;

public final class UnsupportedOSBuildItem
extends MultiBuildItem {
    public static String ARCH = System.getProperty("os.arch");
    public final Os os;
    public final Arch arch;
    public final String error;

    public UnsupportedOSBuildItem(Os os, String error) {
        this.os = os;
        this.arch = Arch.NONE;
        this.error = error;
    }

    public UnsupportedOSBuildItem(Arch arch, String error) {
        this.os = Os.NONE;
        this.arch = arch;
        this.error = error;
    }

    public UnsupportedOSBuildItem(Os os, Arch arch, String error) {
        this.os = os;
        this.arch = arch;
        this.error = error;
    }

    public boolean triggerError(boolean isContainerBuild) {
        return this.os.active && !isContainerBuild || isContainerBuild && this.os == Os.LINUX || this.arch.active;
    }

    public static enum Os {
        WINDOWS(QuarkusConsole.IS_WINDOWS),
        MAC(QuarkusConsole.IS_MAC),
        LINUX(QuarkusConsole.IS_LINUX),
        NONE(false);

        public final boolean active;

        private Os(boolean active) {
            this.active = active;
        }
    }

    public static enum Arch {
        AMD64("amd64".equalsIgnoreCase(ARCH)),
        AARCH64("aarch64".equalsIgnoreCase(ARCH)),
        NONE(false);

        public final boolean active;

        private Arch(boolean active) {
            this.active = active;
        }
    }
}

