/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ConfigBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.runtime.configuration.SystemOnlySourcesConfigBuilder;
import io.quarkus.runtime.graal.InetRunTime;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValidator;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.Converter;

class ConfigBuildSteps {
    static final String SERVICES_PREFIX = "META-INF/services/";

    ConfigBuildSteps() {
    }

    @BuildStep
    void nativeServiceProviders(BuildProducer<ServiceProviderBuildItem> providerProducer) throws IOException {
        providerProducer.produce(new ServiceProviderBuildItem(ConfigProviderResolver.class.getName(), SmallRyeConfigProviderResolver.class.getName()));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (Class serviceClass : Arrays.asList(Converter.class, ConfigSourceInterceptor.class, ConfigSourceInterceptorFactory.class, SecretKeysHandler.class, SecretKeysHandlerFactory.class, ConfigValidator.class)) {
            String serviceName = serviceClass.getName();
            Set<String> names = ServiceUtil.classNamesNamedIn(classLoader, SERVICES_PREFIX + serviceName);
            if (names.isEmpty()) continue;
            providerProducer.produce(new ServiceProviderBuildItem(serviceName, names));
        }
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitializedClass() {
        return new RuntimeInitializedClassBuildItem(InetRunTime.class.getName());
    }

    @BuildStep(onlyIf={SystemOnlySources.class})
    void systemOnlySources(BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(SystemOnlySourcesConfigBuilder.class.getName()));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(SystemOnlySourcesConfigBuilder.class.getName()));
    }

    private static class SystemOnlySources
    implements BooleanSupplier {
        ConfigBuildTimeConfig configBuildTimeConfig;

        private SystemOnlySources() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.configBuildTimeConfig.systemOnly;
        }
    }
}

