/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.SetClassPathSystemPropBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.ClassPathSystemPropertyRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class ClassPathSystemPropBuildStep {
    @BuildStep
    public void produce(BuildProducer<SetClassPathSystemPropBuildItem> producer, CurateOutcomeBuildItem curateOutcome) {
        boolean truffleUsed = curateOutcome.getApplicationModel().getDependencies().stream().anyMatch(d -> d.getGroupId().equals("org.graalvm.polyglot"));
        if (truffleUsed) {
            producer.produce(new SetClassPathSystemPropBuildItem());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void set(List<SetClassPathSystemPropBuildItem> setCPItems, CurateOutcomeBuildItem curateOutcome, ClassPathSystemPropertyRecorder recorder) {
        if (setCPItems.isEmpty()) {
            return;
        }
        Collection runtimeDependencies = curateOutcome.getApplicationModel().getRuntimeDependencies();
        ArrayList parentFirst = new ArrayList();
        ArrayList regular = new ArrayList();
        for (ResolvedDependency dependency : runtimeDependencies) {
            if (dependency.isClassLoaderParentFirst()) {
                parentFirst.addAll(dependency.getContentTree().getRoots());
                continue;
            }
            regular.addAll(dependency.getContentTree().getRoots());
        }
        List<String> allJarPaths = Stream.concat(parentFirst.stream(), regular.stream()).map(p -> p.toAbsolutePath().toString()).toList();
        recorder.set(allJarPaths);
    }
}

