/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.jib.deployment;

import com.google.cloud.tools.jib.api.buildplan.Platform;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

final class PlatformHelper {
    private static final Logger log = Logger.getLogger(PlatformHelper.class);
    public static final String OS_DEFAULT = "linux";
    public static final String ARCH_DEFAULT = "amd64";

    private PlatformHelper() {
    }

    private static Optional<String> normalizeOs(String os) {
        if ((os = os.trim().toLowerCase()).isEmpty()) {
            return Optional.empty();
        }
        switch (os) {
            case "macos": {
                os = "darwin";
            }
        }
        return Optional.of(os);
    }

    private static boolean isKnownOs(String os) {
        switch (os) {
            case "aix": 
            case "android": 
            case "darwin": 
            case "dragonfly": 
            case "freebsd": 
            case "hurd": 
            case "illumos": 
            case "js": 
            case "linux": 
            case "nacl": 
            case "netbsd": 
            case "openbsd": 
            case "plan9": 
            case "solaris": 
            case "windows": 
            case "zos": {
                return true;
            }
        }
        return false;
    }

    private static boolean isKnownArch(String arch) {
        String[] elements = arch.split("/", 2);
        switch (elements[0]) {
            case "386": 
            case "amd64": 
            case "arm64": 
            case "arm": 
            case "amd64p32": 
            case "armbe": 
            case "arm64be": 
            case "ppc64": 
            case "ppc64le": 
            case "mips": 
            case "mipsle": 
            case "mips64": 
            case "mips64le": 
            case "mips64p32": 
            case "mips64p32le": {
                return true;
            }
        }
        return false;
    }

    private static Optional<String> normalizeArch(String arch) {
        String[] elements = arch.split("/", 2);
        if (elements[0].isEmpty()) {
            return Optional.empty();
        }
        Optional<Object> variant = elements.length == 1 || elements[1].isEmpty() ? Optional.empty() : Optional.of(elements[1].trim().toLowerCase());
        switch (arch = elements[0].trim().toLowerCase()) {
            case "i386": {
                arch = "386";
                break;
            }
            case "x86_64": 
            case "x86-64": {
                arch = ARCH_DEFAULT;
                break;
            }
            case "aarch64": 
            case "arm64": {
                arch = "arm64";
                if (!variant.filter(v -> v.equals("8") || v.equals("v8")).isPresent()) break;
                variant = Optional.empty();
                break;
            }
            case "armhf": {
                arch = "arm";
                variant = Optional.of("v7");
                break;
            }
            case "armel": {
                arch = "arm";
                variant = Optional.of("v6");
                break;
            }
            case "arm": {
                if (!variant.isPresent()) {
                    variant = Optional.of("v7");
                    break;
                }
                if (!((String)variant.get()).matches("\\d+")) break;
                variant = Optional.of("v" + (String)variant.get());
            }
        }
        return Optional.of(variant.isPresent() ? arch + "/" + (String)variant.get() : arch);
    }

    public static Platform parse(String specifier) {
        Optional<String> arch;
        Optional<String> os;
        String[] elements = specifier.split("/", 2);
        Platform platform = elements.length == 1 ? ((os = PlatformHelper.normalizeOs(elements[0])).filter(PlatformHelper::isKnownOs).isPresent() ? new Platform(ARCH_DEFAULT, os.get()) : new Platform(PlatformHelper.normalizeArch(elements[0]).orElse(ARCH_DEFAULT), OS_DEFAULT)) : ((arch = PlatformHelper.normalizeArch(specifier)).filter(PlatformHelper::isKnownArch).isPresent() ? new Platform(arch.get(), OS_DEFAULT) : new Platform(PlatformHelper.normalizeArch(elements[1]).orElse(ARCH_DEFAULT), PlatformHelper.normalizeOs(elements[0]).orElse(OS_DEFAULT)));
        log.debug((Object)("Platform Added=" + PlatformHelper.platformToString(platform) + " from specifier: " + specifier));
        return platform;
    }

    public static String platformToString(Platform platform) {
        return platform.getOs() + "/" + platform.getArchitecture();
    }

    public static Set<Platform> parse(Collection<String> platformSpecifiers) {
        return platformSpecifiers.stream().map(PlatformHelper::parse).collect(Collectors.toSet());
    }
}

