/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.jib.deployment;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.FilePermissionsProvider;
import com.google.cloud.tools.jib.api.buildplan.OwnershipProvider;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.EnablementUtil;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.image.jib.deployment.ContainerBuilderHelper;
import io.quarkus.container.image.jib.deployment.ContainerImageJibConfig;
import io.quarkus.container.image.jib.deployment.JibBuild;
import io.quarkus.container.image.jib.deployment.PlatformHelper;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.images.ContainerImages;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveContainerImageBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveResultBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UpxCompressedBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.ResettableSystemProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class JibProcessor {
    private static final Logger log = Logger.getLogger(JibProcessor.class);
    public static final String JIB = "jib";
    private static final IsClassPredicate IS_CLASS_PREDICATE = new IsClassPredicate();
    private static final String BINARY_NAME_IN_CONTAINER = "application";
    private static final String RUN_JAVA_PATH = "/opt/jboss/container/java/run/run-java.sh";
    private static final String DEFAULT_BASE_IMAGE_USER = "185";
    private static final String OPENTELEMETRY_CONTEXT_CONTEXT_STORAGE_PROVIDER_SYS_PROP = "io.opentelemetry.context.contextStorageProvider";
    private static final FilePermissions REMOTE_DEV_FOLDER_PERMISSIONS = FilePermissions.fromOctalString((String)"777");
    private static final FilePermissions REMOTE_DEV_FILE_PERMISSIONS = FilePermissions.fromOctalString((String)"666");
    private static final FilePermissionsProvider REMOTE_DEV_FOLDER_PERMISSIONS_PROVIDER = (sourcePath, destinationPath) -> Files.isDirectory(sourcePath, new LinkOption[0]) ? REMOTE_DEV_FOLDER_PERMISSIONS : REMOTE_DEV_FILE_PERMISSIONS;
    private static final OwnershipProvider REMOTE_DEV_OWNERSHIP_PROVIDER = (sourcePath, destinationPath) -> "185";

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem(JIB);
    }

    @BuildStep(onlyIf={JibBuild.class})
    public void jvmStartupOptimizerArchive(ContainerImageConfig containerImageConfig, CompiledJavaVersionBuildItem compiledJavaVersion, ContainerImageJibConfig jibConfig, BuildProducer<JvmStartupOptimizerArchiveContainerImageBuildItem> producer) {
        if (!containerImageConfig.isBuildExplicitlyEnabled() && !containerImageConfig.isPushExplicitlyEnabled()) {
            return;
        }
        producer.produce((BuildItem)new JvmStartupOptimizerArchiveContainerImageBuildItem(this.determineBaseJvmImage(jibConfig, compiledJavaVersion)));
    }

    private String determineBaseJvmImage(ContainerImageJibConfig jibConfig, CompiledJavaVersionBuildItem compiledJavaVersion) {
        if (jibConfig.baseJvmImage().isPresent()) {
            return jibConfig.baseJvmImage().get();
        }
        return ContainerImages.getDefaultJvmImage((CompiledJavaVersionBuildItem.JavaVersion)compiledJavaVersion.getJavaVersion());
    }

    @BuildStep(onlyIf={IsNormal.class, JibBuild.class}, onlyIfNot={NativeBuild.class})
    public void buildFromJar(ContainerImageConfig containerImageConfig, ContainerImageJibConfig jibConfig, PackageConfig packageConfig, ContainerImageInfoBuildItem containerImage, JarBuildItem sourceJar, MainClassBuildItem mainClass, OutputTargetBuildItem outputTarget, CurateOutcomeBuildItem curateOutcome, CompiledJavaVersionBuildItem compiledJavaVersion, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<JvmStartupOptimizerArchiveResultBuildItem> jvmStartupOptimizerArchiveResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (!buildContainerImage && !pushContainerImage) {
            return;
        }
        PackageConfig.JarConfig.JarType jarType = packageConfig.jar().type();
        JibContainerBuilder jibContainerBuilder = switch (jarType) {
            default -> throw new IncompatibleClassChangeError();
            case PackageConfig.JarConfig.JarType.LEGACY_JAR, PackageConfig.JarConfig.JarType.UBER_JAR -> this.createContainerBuilderFromLegacyJar(this.determineBaseJvmImage(jibConfig, compiledJavaVersion), jibConfig, containerImageConfig, sourceJar, outputTarget, mainClass, containerImageLabels);
            case PackageConfig.JarConfig.JarType.FAST_JAR, PackageConfig.JarConfig.JarType.MUTABLE_JAR -> this.createContainerBuilderFromFastJar(this.determineBaseJvmImage(jibConfig, compiledJavaVersion), jibConfig, containerImageConfig, sourceJar, curateOutcome, containerImageLabels, jvmStartupOptimizerArchiveResult, jarType == PackageConfig.JarConfig.JarType.MUTABLE_JAR);
        };
        this.setUser(jibConfig, jibContainerBuilder);
        this.setPlatforms(jibConfig, jibContainerBuilder);
        this.handleExtraFiles(outputTarget, jibContainerBuilder);
        log.info((Object)"Starting (local) container image build for jar using jib.");
        JibContainer container = this.containerize(containerImageConfig, jibConfig, containerImage, jibContainerBuilder, pushRequest.isPresent());
        this.writeOutputFiles(container, jibConfig, outputTarget);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Map.of("container-image", container.getTargetImage().toString(), "pull-required", Boolean.toString(pushContainerImage))));
        containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(JIB));
    }

    @BuildStep(onlyIf={IsNormal.class, JibBuild.class, NativeBuild.class})
    public void buildFromNative(ContainerImageConfig containerImageConfig, ContainerImageJibConfig jibConfig, ContainerImageInfoBuildItem containerImage, NativeImageBuildItem nativeImage, OutputTargetBuildItem outputTarget, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<UpxCompressedBuildItem> upxCompressed, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (!buildContainerImage && !pushContainerImage) {
            return;
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        JibContainerBuilder jibContainerBuilder = this.createContainerBuilderFromNative(jibConfig, containerImageConfig, nativeImage, containerImageLabels);
        this.setUser(jibConfig, jibContainerBuilder);
        this.setPlatforms(jibConfig, jibContainerBuilder);
        this.handleExtraFiles(outputTarget, jibContainerBuilder);
        log.info((Object)"Starting (local) container image build for native binary using jib.");
        JibContainer container = this.containerize(containerImageConfig, jibConfig, containerImage, jibContainerBuilder, pushContainerImage);
        this.writeOutputFiles(container, jibConfig, outputTarget);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Map.of("container-image", container.getTargetImage().toString(), "pull-required", "" + pushContainerImage)));
        containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(JIB));
    }

    private JibContainer containerize(ContainerImageConfig containerImageConfig, ContainerImageJibConfig jibConfig, ContainerImageInfoBuildItem containerImage, JibContainerBuilder jibContainerBuilder, boolean pushRequested) {
        JibContainer jibContainer;
        block9: {
            Containerizer containerizer = this.createContainerizer(containerImageConfig, jibConfig, containerImage, pushRequested);
            for (String additionalTag : containerImage.getAdditionalTags()) {
                containerizer.withAdditionalTag(additionalTag);
            }
            ResettableSystemProperties resettableSystemProperties = ResettableSystemProperties.of((String)OPENTELEMETRY_CONTEXT_CONTEXT_STORAGE_PROVIDER_SYS_PROP, (String)"default");
            try {
                JibContainer container = this.containerizeUnderLock(jibContainerBuilder, containerizer);
                log.infof("%s container image %s (%s)\n", (Object)(containerImageConfig.isPushExplicitlyEnabled() ? "Pushed" : "Created"), (Object)container.getTargetImage(), (Object)container.getDigest());
                jibContainer = container;
                if (resettableSystemProperties == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resettableSystemProperties != null) {
                        try {
                            resettableSystemProperties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create container image", e);
                }
            }
            resettableSystemProperties.close();
        }
        return jibContainer;
    }

    private Containerizer createContainerizer(ContainerImageConfig containerImageConfig, ContainerImageJibConfig jibConfig, ContainerImageInfoBuildItem containerImageInfo, boolean pushRequested) {
        Containerizer containerizer;
        ImageReference imageReference = ImageReference.of((String)containerImageInfo.getRegistry().orElse(null), (String)containerImageInfo.getRepository(), (String)containerImageInfo.getTag());
        if (pushRequested || containerImageConfig.isPushExplicitlyEnabled()) {
            if (imageReference.getRegistry() == null) {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
            }
            RegistryImage registryImage = this.toRegistryImage(imageReference, containerImageConfig.username(), containerImageConfig.password());
            containerizer = Containerizer.to((RegistryImage)registryImage);
        } else {
            DockerDaemonImage dockerDaemonImage = DockerDaemonImage.named((ImageReference)imageReference);
            Optional dockerConfigExecutableName = ConfigProvider.getConfig().getOptionalValue("quarkus.docker.executable-name", String.class);
            Optional<String> jibConfigExecutableName = jibConfig.dockerExecutableName();
            if (jibConfigExecutableName.isPresent()) {
                dockerDaemonImage.setDockerExecutable(Paths.get(jibConfigExecutableName.get(), new String[0]));
            } else if (dockerConfigExecutableName.isPresent()) {
                dockerDaemonImage.setDockerExecutable(Paths.get((String)dockerConfigExecutableName.get(), new String[0]));
            } else {
                ContainerRuntimeUtil.ContainerRuntime detectedContainerRuntime = ContainerRuntimeUtil.detectContainerRuntime();
                log.infof("Using %s to run the native image builder", (Object)detectedContainerRuntime.getExecutableName());
                dockerDaemonImage.setDockerExecutable(Paths.get(detectedContainerRuntime.getExecutableName(), new String[0]));
            }
            dockerDaemonImage.setDockerEnvironment(jibConfig.dockerEnvironment());
            containerizer = Containerizer.to((DockerDaemonImage)dockerDaemonImage);
        }
        containerizer.setToolName("Quarkus");
        containerizer.setToolVersion(Version.getVersion());
        containerizer.addEventHandler(LogEvent.class, e -> {
            if (!e.getMessage().isEmpty()) {
                log.log(this.toJBossLoggingLevel(e.getLevel()), (Object)e.getMessage());
            }
        });
        containerizer.setAllowInsecureRegistries(containerImageConfig.insecure());
        containerizer.setAlwaysCacheBaseImage(jibConfig.alwaysCacheBaseImage());
        containerizer.setOfflineMode(jibConfig.offlineMode());
        jibConfig.baseImageLayersCache().ifPresent(cacheDir -> containerizer.setBaseImageLayersCache(Paths.get(cacheDir, new String[0])));
        jibConfig.applicationLayersCache().ifPresent(cacheDir -> containerizer.setApplicationLayersCache(Paths.get(cacheDir, new String[0])));
        return containerizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JibContainer containerizeUnderLock(JibContainerBuilder jibContainerBuilder, Containerizer containerizer) throws InterruptedException, RegistryException, IOException, CacheDirectoryCreationException, ExecutionException {
        Class<?> lockObj = this.getClass();
        ClassLoader parentCL = this.getClass().getClassLoader().getParent();
        try {
            lockObj = parentCL.loadClass("io.quarkus.deployment.QuarkusAugmentor");
        }
        catch (ClassNotFoundException e) {
            log.warnf("Could not load io.quarkus.deployment.QuarkusAugmentor with parent classloader: %s", (Object)parentCL);
        }
        Class<?> clazz = lockObj;
        synchronized (clazz) {
            return jibContainerBuilder.containerize(containerizer);
        }
    }

    private void writeOutputFiles(JibContainer jibContainer, ContainerImageJibConfig jibConfig, OutputTargetBuildItem outputTarget) {
        this.doWriteOutputFile(outputTarget, Paths.get(jibConfig.imageDigestFile(), new String[0]), jibContainer.getDigest().toString());
        this.doWriteOutputFile(outputTarget, Paths.get(jibConfig.imageIdFile(), new String[0]), jibContainer.getImageId().toString());
    }

    private void doWriteOutputFile(OutputTargetBuildItem outputTarget, Path configPath, String output) {
        if (!configPath.isAbsolute()) {
            configPath = outputTarget.getOutputDirectory().resolve(configPath);
        }
        try {
            Files.write(configPath, output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Unable to write file '%s'.", (Object)configPath.toAbsolutePath().toString());
        }
    }

    private JibContainerBuilder toJibContainerBuilder(String baseImage, ContainerImageJibConfig jibConfig) throws InvalidImageReferenceException {
        if (baseImage.startsWith("tar://") || baseImage.startsWith("docker://")) {
            return Jib.from((String)baseImage);
        }
        return Jib.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)baseImage), jibConfig.baseRegistryUsername(), jibConfig.baseRegistryPassword()));
    }

    private RegistryImage toRegistryImage(ImageReference imageReference, Optional<String> username, Optional<String> password) {
        CredentialRetrieverFactory credentialRetrieverFactory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, arg_0 -> ((Logger)log).info(arg_0));
        RegistryImage registryImage = RegistryImage.named((ImageReference)imageReference);
        if (username.isPresent() && password.isPresent()) {
            registryImage.addCredential(username.get(), password.get());
        } else {
            String dockerConfigEnv;
            registryImage.addCredentialRetriever(credentialRetrieverFactory.wellKnownCredentialHelpers());
            registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig());
            registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig(Paths.get(System.getProperty("user.home"), ".config", "containers", "auth.json")));
            String xdgRuntimeDir = System.getenv("XDG_RUNTIME_DIR");
            if (xdgRuntimeDir != null && !xdgRuntimeDir.isEmpty()) {
                registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig(Paths.get(xdgRuntimeDir, "containers", "auth.json")));
            }
            if ((dockerConfigEnv = System.getenv().get("DOCKER_CONFIG")) != null) {
                Path dockerConfigPath = Path.of(dockerConfigEnv, new String[0]);
                if (Files.isDirectory(dockerConfigPath, new LinkOption[0])) {
                    dockerConfigPath = dockerConfigPath.resolve("config.json");
                }
                registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig(dockerConfigPath));
            }
            registryImage.addCredentialRetriever(credentialRetrieverFactory.googleApplicationDefaultCredentials());
        }
        return registryImage;
    }

    private Logger.Level toJBossLoggingLevel(LogEvent.Level level) {
        return switch (level) {
            case LogEvent.Level.ERROR -> Logger.Level.ERROR;
            case LogEvent.Level.WARN -> Logger.Level.WARN;
            case LogEvent.Level.LIFECYCLE -> Logger.Level.INFO;
            default -> Logger.Level.DEBUG;
        };
    }

    private JibContainerBuilder createContainerBuilderFromFastJar(String baseJvmImage, ContainerImageJibConfig jibConfig, ContainerImageConfig containerImageConfig, JarBuildItem sourceJarBuildItem, CurateOutcomeBuildItem curateOutcome, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<JvmStartupOptimizerArchiveResultBuildItem> maybeJvmStartupOptimizerArchiveResult, boolean isMutableJar) {
        List<String> entrypoint;
        Path componentsPath = sourceJarBuildItem.getPath().getParent();
        Path appLibDir = componentsPath.resolve("lib").resolve("main");
        AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)jibConfig.workingDirectory());
        Map<String, String> envVars = this.createEnvironmentVariables(jibConfig);
        if (jibConfig.jvmEntrypoint().isPresent()) {
            entrypoint = Collections.unmodifiableList(jibConfig.jvmEntrypoint().get());
        } else if (this.containsRunJava(baseJvmImage) && maybeJvmStartupOptimizerArchiveResult.isEmpty()) {
            entrypoint = List.of(RUN_JAVA_PATH);
            envVars.put("JAVA_APP_JAR", String.valueOf(workDirInContainer) + "/quarkus-run.jar");
            envVars.put("JAVA_APP_DIR", workDirInContainer.toString());
            envVars.put("JAVA_OPTS_APPEND", String.join((CharSequence)" ", this.determineEffectiveJvmArguments(jibConfig, maybeJvmStartupOptimizerArchiveResult, isMutableJar)));
        } else {
            List<String> effectiveJvmArguments = this.determineEffectiveJvmArguments(jibConfig, maybeJvmStartupOptimizerArchiveResult, isMutableJar);
            ArrayList<String> argsList = new ArrayList<String>(3 + effectiveJvmArguments.size());
            argsList.add("java");
            argsList.addAll(effectiveJvmArguments);
            argsList.add("-jar");
            argsList.add("quarkus-run.jar");
            entrypoint = Collections.unmodifiableList(argsList);
        }
        ArrayList<ResolvedDependency> fastChangingLibs = new ArrayList<ResolvedDependency>();
        Collection userDependencies = curateOutcome.getApplicationModel().getRuntimeDependencies();
        for (ResolvedDependency artifact : userDependencies) {
            if (artifact == null) continue;
            if (artifact.isWorkspaceModule()) {
                fastChangingLibs.add(artifact);
                continue;
            }
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null || artifactVersion.isEmpty() || !artifactVersion.toLowerCase().contains("snapshot")) continue;
            fastChangingLibs.add(artifact);
        }
        Set fastChangingLibPaths = Collections.emptySet();
        ArrayList<Path> nonFastChangingLibPaths = null;
        if (!fastChangingLibs.isEmpty()) {
            fastChangingLibPaths = new HashSet(fastChangingLibs.size());
            HashMap<String, Path> libNameToPath = new HashMap<String, Path>();
            try (DirectoryStream<Path> allLibPaths = Files.newDirectoryStream(appLibDir);){
                for (Path path : allLibPaths) {
                    libNameToPath.put(path.getFileName().toString(), path);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ArrayList libFileNames = new ArrayList(libNameToPath.keySet());
            for (ResolvedDependency resolvedDependency : fastChangingLibs) {
                String matchingLibDirFileName = null;
                for (Path appArtifactPath : resolvedDependency.getResolvedPaths()) {
                    for (String libFileName : libFileNames) {
                        if (!libFileName.contains(resolvedDependency.getGroupId()) || !libFileName.contains(appArtifactPath.getFileName().toString())) continue;
                        matchingLibDirFileName = libFileName;
                        break;
                    }
                    if (matchingLibDirFileName == null) continue;
                    break;
                }
                if (matchingLibDirFileName == null) continue;
                fastChangingLibPaths.add((Path)libNameToPath.get(matchingLibDirFileName));
            }
            Collection allLibPaths = libNameToPath.values();
            nonFastChangingLibPaths = new ArrayList<Path>(allLibPaths.size() - fastChangingLibPaths.size());
            for (Path libPath : allLibPaths) {
                if (fastChangingLibPaths.contains(libPath)) continue;
                nonFastChangingLibPaths.add(libPath);
            }
        }
        try {
            Instant now = Instant.now();
            boolean enforceModificationTime = !jibConfig.useCurrentTimestampFileModification();
            Instant modificationTime = jibConfig.useCurrentTimestampFileModification() ? now : Instant.EPOCH;
            JibContainerBuilder jibContainerBuilder = this.toJibContainerBuilder(baseJvmImage, jibConfig);
            if (fastChangingLibPaths.isEmpty()) {
                this.addLayer(jibContainerBuilder, Collections.singletonList(componentsPath.resolve("lib")), workDirInContainer, "fast-jar-lib", isMutableJar, enforceModificationTime, modificationTime);
            } else {
                FileEntriesLayer.Builder bootLibsLayerBuilder = FileEntriesLayer.builder().setName("fast-jar-boot-libs");
                Path bootLibPath = componentsPath.resolve("lib").resolve("boot");
                try (Stream<Path> bootLibPaths = Files.list(bootLibPath);){
                    bootLibPaths.forEach(lib -> {
                        try {
                            AbsoluteUnixPath libPathInContainer = workDirInContainer.resolve("lib").resolve("boot").resolve(lib.getFileName());
                            Instant bootLibModificationTime = maybeJvmStartupOptimizerArchiveResult.isPresent() ? Files.getLastModifiedTime(lib, new LinkOption[0]).toInstant() : modificationTime;
                            bootLibsLayerBuilder.addEntry(lib, libPathInContainer, bootLibModificationTime);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                jibContainerBuilder.addFileEntriesLayer(bootLibsLayerBuilder.build());
                if (isMutableJar) {
                    Path deploymentPath = componentsPath.resolve("lib").resolve("deployment");
                    this.addLayer(jibContainerBuilder, Collections.singletonList(deploymentPath), workDirInContainer.resolve("lib"), "fast-jar-deployment-libs", true, enforceModificationTime, modificationTime);
                }
                AbsoluteUnixPath libsMainPath = workDirInContainer.resolve("lib").resolve("main");
                this.addLayer(jibContainerBuilder, nonFastChangingLibPaths, libsMainPath, "fast-jar-normal-libs", isMutableJar, enforceModificationTime, modificationTime);
                this.addLayer(jibContainerBuilder, new ArrayList<Path>(fastChangingLibPaths), libsMainPath, "fast-jar-changing-libs", isMutableJar, enforceModificationTime, modificationTime);
            }
            if (maybeJvmStartupOptimizerArchiveResult.isPresent()) {
                jibContainerBuilder.addFileEntriesLayer(FileEntriesLayer.builder().setName("app-cds").addEntry(componentsPath.resolve("quarkus-run.jar"), workDirInContainer.resolve("quarkus-run.jar"), Files.getLastModifiedTime(componentsPath.resolve("quarkus-run.jar"), new LinkOption[0]).toInstant()).build());
                jibContainerBuilder.addLayer(Collections.singletonList(maybeJvmStartupOptimizerArchiveResult.get().getArchive()), workDirInContainer);
            } else {
                jibContainerBuilder.addFileEntriesLayer(FileEntriesLayer.builder().setName("fast-jar-run").addEntry(componentsPath.resolve("quarkus-run.jar"), workDirInContainer.resolve("quarkus-run.jar"), isMutableJar ? REMOTE_DEV_FILE_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS, modificationTime, isMutableJar ? DEFAULT_BASE_IMAGE_USER : "").build());
            }
            this.addLayer(jibContainerBuilder, Collections.singletonList(componentsPath.resolve("app")), workDirInContainer, "fast-jar-quarkus-app", isMutableJar, enforceModificationTime, modificationTime);
            this.addLayer(jibContainerBuilder, Collections.singletonList(componentsPath.resolve("quarkus")), workDirInContainer, "fast-jar-quarkus", isMutableJar, enforceModificationTime, modificationTime);
            if ("/home/jboss".equals(jibConfig.workingDirectory())) {
                jibContainerBuilder.addFileEntriesLayer(FileEntriesLayer.builder().addEntry(new FileEntry(Files.createTempDirectory(JIB, new FileAttribute[0]), AbsoluteUnixPath.get((String)jibConfig.workingDirectory()), FilePermissions.DEFAULT_FOLDER_PERMISSIONS, modificationTime, DEFAULT_BASE_IMAGE_USER)).build());
            }
            if (isMutableJar) {
                jibContainerBuilder.addFileEntriesLayer(FileEntriesLayer.builder().addEntry(new FileEntry(Files.createTempDirectory(JIB, new FileAttribute[0]), workDirInContainer.resolve("dev"), REMOTE_DEV_FOLDER_PERMISSIONS, modificationTime, DEFAULT_BASE_IMAGE_USER)).addEntry(new FileEntry(componentsPath.resolve("quarkus-app-dependencies.txt"), workDirInContainer.resolve("quarkus-app-dependencies.txt"), REMOTE_DEV_FOLDER_PERMISSIONS, modificationTime, DEFAULT_BASE_IMAGE_USER)).build());
            }
            jibContainerBuilder.setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(envVars).setLabels(this.allLabels(jibConfig, containerImageConfig, containerImageLabels));
            this.mayInheritEntrypoint(jibContainerBuilder, entrypoint, jibConfig.jvmArguments());
            if (jibConfig.useCurrentTimestamp()) {
                jibContainerBuilder.setCreationTime(now);
            }
            for (int port : jibConfig.ports()) {
                jibContainerBuilder.addExposedPort(Port.tcp((int)port));
            }
            return jibContainerBuilder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsRunJava(String baseJvmImage) {
        return baseJvmImage.startsWith("registry.access.redhat.com/ubi8/openjdk-17-runtime") || baseJvmImage.startsWith("registry.access.redhat.com/ubi8/openjdk-21-runtime") || baseJvmImage.startsWith("registry.access.redhat.com/ubi9/openjdk-17-runtime") || baseJvmImage.startsWith("registry.access.redhat.com/ubi9/openjdk-21-runtime");
    }

    public JibContainerBuilder addLayer(JibContainerBuilder jibContainerBuilder, List<Path> files, AbsoluteUnixPath pathInContainer, String name, boolean isMutableJar, boolean enforceModificationTime, Instant forcedModificationTime) throws IOException {
        FileEntriesLayer.Builder layerConfigurationBuilder = FileEntriesLayer.builder().setName(name);
        for (Path file : files) {
            layerConfigurationBuilder.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()), isMutableJar ? REMOTE_DEV_FOLDER_PERMISSIONS_PROVIDER : FileEntriesLayer.DEFAULT_FILE_PERMISSIONS_PROVIDER, (sourcePath, destinationPath) -> {
                if (enforceModificationTime) {
                    return forcedModificationTime;
                }
                try {
                    return Files.getLastModifiedTime(sourcePath, new LinkOption[0]).toInstant();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get last modified time for " + String.valueOf(sourcePath), e);
                }
            }, isMutableJar ? REMOTE_DEV_OWNERSHIP_PROVIDER : FileEntriesLayer.DEFAULT_OWNERSHIP_PROVIDER);
        }
        return jibContainerBuilder.addFileEntriesLayer(layerConfigurationBuilder.build());
    }

    private void mayInheritEntrypoint(JibContainerBuilder jibContainerBuilder, List<String> entrypoint, List<String> arguments) {
        if (entrypoint.size() == 1 && "INHERIT".equals(entrypoint.get(0))) {
            jibContainerBuilder.setEntrypoint((List)null).setProgramArguments(arguments);
        }
    }

    private List<String> determineEffectiveJvmArguments(ContainerImageJibConfig jibConfig, Optional<JvmStartupOptimizerArchiveResultBuildItem> maybeJvmStartupOptimizerArchiveResult, boolean isMutableJar) {
        ArrayList<String> effectiveJvmArguments = new ArrayList<String>(jibConfig.jvmArguments());
        jibConfig.jvmAdditionalArguments().ifPresent(effectiveJvmArguments::addAll);
        if (maybeJvmStartupOptimizerArchiveResult.isPresent()) {
            JvmStartupOptimizerArchiveResultBuildItem appCDSResult = maybeJvmStartupOptimizerArchiveResult.get();
            boolean containsAppCDSOptions = false;
            for (String effectiveJvmArgument : effectiveJvmArguments) {
                if (!effectiveJvmArgument.startsWith(appCDSResult.getType().getJvmFlag())) continue;
                containsAppCDSOptions = true;
                break;
            }
            if (!containsAppCDSOptions) {
                effectiveJvmArguments.add(appCDSResult.getType().getJvmFlag() + "=" + appCDSResult.getArchive().getFileName().toString());
            }
        }
        if (isMutableJar) {
            effectiveJvmArguments.add("-Dquarkus.package.output-directory=${PWD}");
        }
        return effectiveJvmArguments;
    }

    private void setUser(ContainerImageJibConfig jibConfig, JibContainerBuilder jibContainerBuilder) {
        jibConfig.user().ifPresent(arg_0 -> ((JibContainerBuilder)jibContainerBuilder).setUser(arg_0));
    }

    private void setPlatforms(ContainerImageJibConfig jibConfig, JibContainerBuilder jibContainerBuilder) {
        jibConfig.platforms().map(PlatformHelper::parse).ifPresent(arg_0 -> ((JibContainerBuilder)jibContainerBuilder).setPlatforms(arg_0));
    }

    private JibContainerBuilder createContainerBuilderFromLegacyJar(String baseJvmImage, ContainerImageJibConfig jibConfig, ContainerImageConfig containerImageConfig, JarBuildItem sourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, MainClassBuildItem mainClassBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        try {
            Path classesDir = outputTargetBuildItem.getOutputDirectory().resolve(JIB);
            ZipUtils.unzip((Path)sourceJarBuildItem.getPath(), (Path)classesDir);
            JavaContainerBuilder javaContainerBuilder = baseJvmImage.startsWith("tar://") || baseJvmImage.startsWith("docker://") ? JavaContainerBuilder.from((String)baseJvmImage) : JavaContainerBuilder.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)baseJvmImage), jibConfig.baseRegistryUsername(), jibConfig.baseRegistryPassword()));
            javaContainerBuilder = javaContainerBuilder.addResources(classesDir, IS_CLASS_PREDICATE.negate()).addClasses(classesDir, (Predicate)IS_CLASS_PREDICATE);
            if (!jibConfig.jvmEntrypoint().isPresent()) {
                javaContainerBuilder.addJvmFlags(this.determineEffectiveJvmArguments(jibConfig, Optional.empty(), false)).setMainClass(mainClassBuildItem.getClassName());
            }
            if (sourceJarBuildItem.getLibraryDir() != null) {
                try (Stream<Path> dependenciesPaths = Files.list(sourceJarBuildItem.getLibraryDir());){
                    javaContainerBuilder.addDependencies(dependenciesPaths.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".jar")).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toList()));
                }
            }
            JibContainerBuilder jibContainerBuilder = javaContainerBuilder.toContainerBuilder().setEnvironment(this.createEnvironmentVariables(jibConfig)).setLabels(this.allLabels(jibConfig, containerImageConfig, containerImageLabels));
            if (jibConfig.useCurrentTimestamp()) {
                jibContainerBuilder.setCreationTime(Instant.now());
            }
            if (jibConfig.jvmEntrypoint().isPresent()) {
                jibContainerBuilder.setEntrypoint(jibConfig.jvmEntrypoint().get());
                this.mayInheritEntrypoint(jibContainerBuilder, jibConfig.jvmEntrypoint().get(), jibConfig.jvmArguments());
            }
            return jibContainerBuilder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private JibContainerBuilder createContainerBuilderFromNative(ContainerImageJibConfig jibConfig, ContainerImageConfig containerImageConfig, NativeImageBuildItem nativeImageBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        List<String> entrypoint;
        if (jibConfig.nativeEntrypoint().isPresent()) {
            entrypoint = jibConfig.nativeEntrypoint().get();
        } else {
            List nativeArguments = jibConfig.nativeArguments().orElse(Collections.emptyList());
            entrypoint = new ArrayList<String>(nativeArguments.size() + 1);
            entrypoint.add("./application");
            entrypoint.addAll(nativeArguments);
        }
        try {
            AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)"/work");
            JibContainerBuilder jibContainerBuilder = this.toJibContainerBuilder(jibConfig.baseNativeImage(), jibConfig).addFileEntriesLayer(FileEntriesLayer.builder().addEntry(nativeImageBuildItem.getPath(), workDirInContainer.resolve(BINARY_NAME_IN_CONTAINER), FilePermissions.fromOctalString((String)"775")).build()).setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(this.createEnvironmentVariables(jibConfig)).setLabels(this.allLabels(jibConfig, containerImageConfig, containerImageLabels));
            this.includeSharedObjects(jibContainerBuilder, nativeImageBuildItem, workDirInContainer);
            this.mayInheritEntrypoint(jibContainerBuilder, entrypoint, jibConfig.nativeArguments().orElse(null));
            if (jibConfig.useCurrentTimestamp()) {
                jibContainerBuilder.setCreationTime(Instant.now());
            }
            for (int port : jibConfig.ports()) {
                jibContainerBuilder.addExposedPort(Port.tcp((int)port));
            }
            return jibContainerBuilder;
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private void includeSharedObjects(JibContainerBuilder jibContainerBuilder, NativeImageBuildItem nativeImageBuildItem, AbsoluteUnixPath workDirInContainer) {
        Path buildDir = nativeImageBuildItem.getPath().getParent();
        try (Stream<Path> paths = Files.list(buildDir);){
            List<Path> sharedObjectFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".so")).toList();
            if (!sharedObjectFiles.isEmpty()) {
                FileEntriesLayer.Builder fileEntriesLayerBuilder = FileEntriesLayer.builder();
                sharedObjectFiles.forEach(sharedObjectFile -> fileEntriesLayerBuilder.addEntry(sharedObjectFile, workDirInContainer.resolve(sharedObjectFile.getFileName().toString()), FilePermissions.fromOctalString((String)"775")));
                jibContainerBuilder.addFileEntriesLayer(fileEntriesLayerBuilder.setName("shared objects").build());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, String> createEnvironmentVariables(ContainerImageJibConfig jibConfig) {
        Map<String, String> original = jibConfig.environmentVariables();
        if (original.isEmpty()) {
            return original;
        }
        HashMap<String, String> converted = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : original.entrySet()) {
            converted.put(entry.getKey().toUpperCase().replace('-', '_').replace('.', '_').replace('/', '_'), entry.getValue());
        }
        return converted;
    }

    private void handleExtraFiles(OutputTargetBuildItem outputTarget, JibContainerBuilder jibContainerBuilder) {
        Path outputDirectory = outputTarget.getOutputDirectory();
        AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
        if (mainSourcesRoot == null) {
            return;
        }
        Path jibFilesRoot = ((Path)mainSourcesRoot.getKey()).resolve(JIB);
        if (!jibFilesRoot.toFile().exists()) {
            return;
        }
        try {
            FileEntriesLayer extraFilesLayer = ContainerBuilderHelper.extraDirectoryLayerConfiguration(jibFilesRoot, AbsoluteUnixPath.get((String)"/"), Collections.emptyMap(), (localPath, ignored2) -> {
                try {
                    return Files.getLastModifiedTime(localPath, new LinkOption[0]).toInstant();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            jibContainerBuilder.addFileEntriesLayer(extraFilesLayer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to add extra files in '" + jibFilesRoot.toAbsolutePath().toString() + "' to the container", e);
        }
    }

    private Map<String, String> allLabels(ContainerImageJibConfig jibConfig, ContainerImageConfig containerImageConfig, List<ContainerImageLabelBuildItem> containerImageLabels) {
        if (containerImageLabels.isEmpty() && containerImageConfig.labels().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> allLabels = new HashMap<String, String>(containerImageConfig.labels());
        for (ContainerImageLabelBuildItem containerImageLabel : containerImageLabels) {
            allLabels.putIfAbsent(containerImageLabel.getName(), containerImageLabel.getValue());
        }
        return allLabels;
    }

    private static class IsClassPredicate
    implements Predicate<Path> {
        private IsClassPredicate() {
        }

        @Override
        public boolean test(Path path) {
            return path.getFileName().toString().endsWith(".class");
        }
    }
}

